/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.ulrich.clans.library.redis.jedis.util.MurmurHash;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public interface Hashing {
    public static final Hashing MURMUR_HASH = new MurmurHash();
    public static final ThreadLocal<MessageDigest> md5Holder = new ThreadLocal();
    public static final Hashing MD5 = new Hashing(){

        @Override
        public long hash(String string) {
            return this.hash(SafeEncoder.encode(string));
        }

        @Override
        public long hash(byte[] byArray) {
            try {
                if (md5Holder.get() == null) {
                    md5Holder.set(MessageDigest.getInstance("MD5"));
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException("++++ no md5 algorithm found");
            }
            MessageDigest messageDigest = (MessageDigest)md5Holder.get();
            messageDigest.reset();
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            return (long)(byArray2[3] & 0xFF) << 24 | (long)(byArray2[2] & 0xFF) << 16 | (long)(byArray2[1] & 0xFF) << 8 | (long)(byArray2[0] & 0xFF);
        }
    };

    public long hash(String var1);

    public long hash(byte[] var1);
}

