/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.timeseries;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.timeseries.AggregationType;
import me.ulrich.clans.library.redis.jedis.timeseries.TimeSeriesProtocol;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class TSRangeParams
implements IParams {
    private Long fromTimestamp;
    private Long toTimestamp;
    private boolean latest;
    private long[] filterByTimestamps;
    private double[] filterByValues;
    private Integer count;
    private byte[] align;
    private AggregationType aggregationType;
    private long bucketDuration;
    private byte[] bucketTimestamp;
    private boolean empty;

    public TSRangeParams(long l2, long l3) {
        this.fromTimestamp = l2;
        this.toTimestamp = l3;
    }

    public static TSRangeParams rangeParams(long l2, long l3) {
        return new TSRangeParams(l2, l3);
    }

    public TSRangeParams() {
    }

    public static TSRangeParams rangeParams() {
        return new TSRangeParams();
    }

    public TSRangeParams fromTimestamp(long l2) {
        this.fromTimestamp = l2;
        return this;
    }

    public TSRangeParams toTimestamp(long l2) {
        this.toTimestamp = l2;
        return this;
    }

    public TSRangeParams latest() {
        this.latest = true;
        return this;
    }

    public TSRangeParams filterByTS(long ... lArray) {
        this.filterByTimestamps = lArray;
        return this;
    }

    public TSRangeParams filterByValues(double d2, double d3) {
        this.filterByValues = new double[]{d2, d3};
        return this;
    }

    public TSRangeParams count(int n2) {
        this.count = n2;
        return this;
    }

    private TSRangeParams align(byte[] byArray) {
        this.align = byArray;
        return this;
    }

    public TSRangeParams align(long l2) {
        return this.align(Protocol.toByteArray(l2));
    }

    public TSRangeParams alignStart() {
        return this.align(TimeSeriesProtocol.MINUS);
    }

    public TSRangeParams alignEnd() {
        return this.align(TimeSeriesProtocol.PLUS);
    }

    public TSRangeParams aggregation(AggregationType aggregationType, long l2) {
        this.aggregationType = aggregationType;
        this.bucketDuration = l2;
        return this;
    }

    public TSRangeParams bucketTimestamp(String string) {
        this.bucketTimestamp = SafeEncoder.encode(string);
        return this;
    }

    public TSRangeParams bucketTimestampLow() {
        this.bucketTimestamp = TimeSeriesProtocol.MINUS;
        return this;
    }

    public TSRangeParams bucketTimestampHigh() {
        this.bucketTimestamp = TimeSeriesProtocol.PLUS;
        return this;
    }

    public TSRangeParams bucketTimestampMid() {
        this.bucketTimestamp = Protocol.BYTES_TILDE;
        return this;
    }

    public TSRangeParams empty() {
        this.empty = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.fromTimestamp == null) {
            commandArguments.add(TimeSeriesProtocol.MINUS);
        } else {
            commandArguments.add(Protocol.toByteArray(this.fromTimestamp));
        }
        if (this.toTimestamp == null) {
            commandArguments.add(TimeSeriesProtocol.PLUS);
        } else {
            commandArguments.add(Protocol.toByteArray(this.toTimestamp));
        }
        if (this.latest) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.LATEST);
        }
        if (this.filterByTimestamps != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER_BY_TS);
            for (long l3 : this.filterByTimestamps) {
                commandArguments.add(Protocol.toByteArray(l3));
            }
        }
        if (this.filterByValues != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER_BY_VALUE);
            for (double d2 : this.filterByValues) {
                commandArguments.add(Protocol.toByteArray(d2));
            }
        }
        if (this.count != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.COUNT).add(Protocol.toByteArray(this.count));
        }
        if (this.aggregationType != null) {
            if (this.align != null) {
                commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.ALIGN).add(this.align);
            }
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(this.aggregationType).add(Protocol.toByteArray(this.bucketDuration));
            if (this.bucketTimestamp != null) {
                commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.BUCKETTIMESTAMP).add(this.bucketTimestamp);
            }
            if (this.empty) {
                commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.EMPTY);
            }
        }
    }
}

