/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.timeseries;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.timeseries.AggregationType;
import me.ulrich.clans.library.redis.jedis.timeseries.TimeSeriesProtocol;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class TSMRangeParams
implements IParams {
    private Long fromTimestamp;
    private Long toTimestamp;
    private boolean latest;
    private long[] filterByTimestamps;
    private double[] filterByValues;
    private boolean withLabels;
    private String[] selectedLabels;
    private Integer count;
    private byte[] align;
    private AggregationType aggregationType;
    private long bucketDuration;
    private byte[] bucketTimestamp;
    private boolean empty;
    private String[] filters;
    private String groupByLabel;
    private String groupByReduce;

    public TSMRangeParams(long l2, long l3) {
        this.fromTimestamp = l2;
        this.toTimestamp = l3;
    }

    public static TSMRangeParams multiRangeParams(long l2, long l3) {
        return new TSMRangeParams(l2, l3);
    }

    public TSMRangeParams() {
    }

    public static TSMRangeParams multiRangeParams() {
        return new TSMRangeParams();
    }

    public TSMRangeParams fromTimestamp(long l2) {
        this.fromTimestamp = l2;
        return this;
    }

    public TSMRangeParams toTimestamp(long l2) {
        this.toTimestamp = l2;
        return this;
    }

    public TSMRangeParams latest() {
        this.latest = true;
        return this;
    }

    public TSMRangeParams filterByTS(long ... lArray) {
        this.filterByTimestamps = lArray;
        return this;
    }

    public TSMRangeParams filterByValues(double d2, double d3) {
        this.filterByValues = new double[]{d2, d3};
        return this;
    }

    public TSMRangeParams withLabels(boolean bl) {
        this.withLabels = bl;
        return this;
    }

    public TSMRangeParams withLabels() {
        return this.withLabels(true);
    }

    public TSMRangeParams selectedLabels(String ... stringArray) {
        this.selectedLabels = stringArray;
        return this;
    }

    public TSMRangeParams count(int n2) {
        this.count = n2;
        return this;
    }

    private TSMRangeParams align(byte[] byArray) {
        this.align = byArray;
        return this;
    }

    public TSMRangeParams align(long l2) {
        return this.align(Protocol.toByteArray(l2));
    }

    public TSMRangeParams alignStart() {
        return this.align(TimeSeriesProtocol.MINUS);
    }

    public TSMRangeParams alignEnd() {
        return this.align(TimeSeriesProtocol.PLUS);
    }

    public TSMRangeParams aggregation(AggregationType aggregationType, long l2) {
        this.aggregationType = aggregationType;
        this.bucketDuration = l2;
        return this;
    }

    public TSMRangeParams bucketTimestamp(String string) {
        this.bucketTimestamp = SafeEncoder.encode(string);
        return this;
    }

    public TSMRangeParams bucketTimestampLow() {
        this.bucketTimestamp = TimeSeriesProtocol.MINUS;
        return this;
    }

    public TSMRangeParams bucketTimestampHigh() {
        this.bucketTimestamp = TimeSeriesProtocol.PLUS;
        return this;
    }

    public TSMRangeParams bucketTimestampMid() {
        this.bucketTimestamp = Protocol.BYTES_TILDE;
        return this;
    }

    public TSMRangeParams empty() {
        this.empty = true;
        return this;
    }

    public TSMRangeParams filter(String ... stringArray) {
        this.filters = stringArray;
        return this;
    }

    public TSMRangeParams groupBy(String string, String string2) {
        this.groupByLabel = string;
        this.groupByReduce = string2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.filters == null) {
            throw new IllegalArgumentException("FILTER arguments must be set.");
        }
        if (this.fromTimestamp == null) {
            commandArguments.add(TimeSeriesProtocol.MINUS);
        } else {
            commandArguments.add(Protocol.toByteArray(this.fromTimestamp));
        }
        if (this.toTimestamp == null) {
            commandArguments.add(TimeSeriesProtocol.PLUS);
        } else {
            commandArguments.add(Protocol.toByteArray(this.toTimestamp));
        }
        if (this.latest) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.LATEST);
        }
        if (this.filterByTimestamps != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER_BY_TS);
            for (long l2 : this.filterByTimestamps) {
                commandArguments.add(Protocol.toByteArray(l2));
            }
        }
        if (this.filterByValues != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER_BY_VALUE);
            for (double d2 : this.filterByValues) {
                commandArguments.add(Protocol.toByteArray(d2));
            }
        }
        if (this.withLabels) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.WITHLABELS);
        } else if (this.selectedLabels != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.SELECTED_LABELS);
            for (String string : this.selectedLabels) {
                commandArguments.add(string);
            }
        }
        if (this.count != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.COUNT).add(Protocol.toByteArray(this.count));
        }
        if (this.aggregationType != null) {
            if (this.align != null) {
                commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.ALIGN).add(this.align);
            }
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(this.aggregationType).add(Protocol.toByteArray(this.bucketDuration));
            if (this.bucketTimestamp != null) {
                commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.BUCKETTIMESTAMP).add(this.bucketTimestamp);
            }
            if (this.empty) {
                commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.EMPTY);
            }
        }
        commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER);
        for (String string : this.filters) {
            commandArguments.add(string);
        }
        if (this.groupByLabel != null && this.groupByReduce != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.GROUPBY).add(this.groupByLabel).add(TimeSeriesProtocol.TimeSeriesKeyword.REDUCE).add(this.groupByReduce);
        }
    }
}

