/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.timeseries.AggregationType;
import me.ulrich.clans.library.redis.jedis.timeseries.DuplicatePolicy;
import me.ulrich.clans.library.redis.jedis.util.DoublePrecision;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class TSInfo {
    private static final String DUPLICATE_POLICY_PROPERTY = "duplicatePolicy";
    private static final String LABELS_PROPERTY = "labels";
    private static final String RULES_PROPERTY = "rules";
    private static final String CHUNKS_PROPERTY = "Chunks";
    private static final String CHUNKS_BYTES_PER_SAMPLE_PROPERTY = "bytesPerSample";
    private final Map<String, Object> properties;
    private final Map<String, String> labels;
    private final Map<String, Rule> rules;
    private final List<Map<String, Object>> chunks;
    public static Builder<TSInfo> TIMESERIES_INFO = new Builder<TSInfo>(){

        @Override
        public TSInfo build(Object object) {
            List list = (List)object;
            HashMap hashMap = new HashMap();
            Map<String, String> map = null;
            HashMap<String, Rule> hashMap2 = null;
            ArrayList<Map<String, Object>> arrayList = null;
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                String string = SafeEncoder.encode((byte[])list.get(i2));
                Object object2 = list.get(i2 + 1);
                if (object2 instanceof List) {
                    switch (string) {
                        case "labels": {
                            map = BuilderFactory.STRING_MAP_FROM_PAIRS.build(object2);
                            object2 = map;
                            break;
                        }
                        case "rules": {
                            Object object3;
                            List list2 = (List)object2;
                            ArrayList<Object> arrayList2 = new ArrayList<Object>(list2.size());
                            hashMap2 = new HashMap<String, Rule>(list2.size());
                            for (ArrayList<HashMap<String, Object>> arrayList3 : list2) {
                                object3 = (List)SafeEncoder.encodeObject(arrayList3);
                                arrayList2.add(object3);
                                hashMap2.put((String)object3.get(0), new Rule((String)object3.get(0), (Long)object3.get(1), AggregationType.safeValueOf((String)object3.get(2)), (Long)object3.get(3)));
                            }
                            object2 = arrayList2;
                            break;
                        }
                        case "Chunks": {
                            ArrayList<HashMap<String, Object>> arrayList3;
                            List list3 = (List)object2;
                            arrayList3 = new ArrayList(list3.size());
                            arrayList = new ArrayList<Map<String, Object>>(list3.size());
                            Object object3 = list3.iterator();
                            while (object3.hasNext()) {
                                Object e2 = object3.next();
                                Map<String, Object> map2 = BuilderFactory.ENCODED_OBJECT_MAP.build(e2);
                                arrayList3.add(new HashMap<String, Object>(map2));
                                if (map2.containsKey(TSInfo.CHUNKS_BYTES_PER_SAMPLE_PROPERTY)) {
                                    map2.put(TSInfo.CHUNKS_BYTES_PER_SAMPLE_PROPERTY, DoublePrecision.parseFloatingPointNumber((String)map2.get(TSInfo.CHUNKS_BYTES_PER_SAMPLE_PROPERTY)));
                                }
                                arrayList.add(map2);
                            }
                            object2 = arrayList3;
                            break;
                        }
                        default: {
                            object2 = SafeEncoder.encodeObject(object2);
                            break;
                        }
                    }
                } else if (object2 instanceof byte[]) {
                    object2 = SafeEncoder.encode((byte[])object2);
                    if (TSInfo.DUPLICATE_POLICY_PROPERTY.equals(string)) {
                        try {
                            object2 = DuplicatePolicy.valueOf(((String)object2).toUpperCase());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                hashMap.put(string, object2);
            }
            return new TSInfo(hashMap, map, hashMap2, arrayList);
        }
    };

    private TSInfo(Map<String, Object> map, Map<String, String> map2, Map<String, Rule> map3, List<Map<String, Object>> list) {
        this.properties = map;
        this.labels = map2;
        this.rules = map3;
        this.chunks = list;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Long getIntegerProperty(String string) {
        return (Long)this.properties.get(string);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getLabel(String string) {
        return this.labels.get(string);
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public Rule getRule(String string) {
        return this.rules.get(string);
    }

    public List<Map<String, Object>> getChunks() {
        return this.chunks;
    }

    public static class Rule {
        private final String compactionKey;
        private final long bucketDuration;
        private final AggregationType aggregator;
        private final long alignmentTimestamp;

        private Rule(String string, long l2, AggregationType aggregationType, long l3) {
            this.compactionKey = string;
            this.bucketDuration = l2;
            this.aggregator = aggregationType;
            this.alignmentTimestamp = l3;
        }

        public String getCompactionKey() {
            return this.compactionKey;
        }

        public long getBucketDuration() {
            return this.bucketDuration;
        }

        public AggregationType getAggregator() {
            return this.aggregator;
        }

        public long getAlignmentTimestamp() {
            return this.alignmentTimestamp;
        }
    }
}

