/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.timeseries;

import java.util.LinkedHashMap;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.timeseries.DuplicatePolicy;
import me.ulrich.clans.library.redis.jedis.timeseries.TimeSeriesProtocol;

public class TSCreateParams
implements IParams {
    private Long retentionPeriod;
    private boolean uncompressed;
    private boolean compressed;
    private Long chunkSize;
    private DuplicatePolicy duplicatePolicy;
    private Map<String, String> labels;

    public static TSCreateParams createParams() {
        return new TSCreateParams();
    }

    public TSCreateParams retention(long l2) {
        this.retentionPeriod = l2;
        return this;
    }

    public TSCreateParams uncompressed() {
        this.uncompressed = true;
        return this;
    }

    public TSCreateParams compressed() {
        this.compressed = true;
        return this;
    }

    public TSCreateParams chunkSize(long l2) {
        this.chunkSize = l2;
        return this;
    }

    public TSCreateParams duplicatePolicy(DuplicatePolicy duplicatePolicy) {
        this.duplicatePolicy = duplicatePolicy;
        return this;
    }

    public TSCreateParams labels(Map<String, String> map) {
        this.labels = map;
        return this;
    }

    public TSCreateParams label(String string, String string2) {
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        this.labels.put(string, string2);
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.retentionPeriod != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.RETENTION).add(Protocol.toByteArray(this.retentionPeriod));
        }
        if (this.uncompressed) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.ENCODING).add(TimeSeriesProtocol.TimeSeriesKeyword.UNCOMPRESSED);
        } else if (this.compressed) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.ENCODING).add(TimeSeriesProtocol.TimeSeriesKeyword.COMPRESSED);
        }
        if (this.chunkSize != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.CHUNK_SIZE).add(Protocol.toByteArray(this.chunkSize));
        }
        if (this.duplicatePolicy != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.DUPLICATE_POLICY).add(this.duplicatePolicy);
        }
        if (this.labels != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.LABELS);
            this.labels.entrySet().forEach(entry -> commandArguments.add(entry.getKey()).add(entry.getValue()));
        }
    }
}

