/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.timeseries;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.timeseries.DuplicatePolicy;
import me.ulrich.clans.library.redis.jedis.timeseries.TimeSeriesProtocol;

public class TSAlterParams
implements IParams {
    private Long retentionPeriod;
    private Long chunkSize;
    private DuplicatePolicy duplicatePolicy;
    private Map<String, String> labels;

    public static TSAlterParams alterParams() {
        return new TSAlterParams();
    }

    @Deprecated
    public TSAlterParams retentionTime(long l2) {
        return this.retention(l2);
    }

    public TSAlterParams retention(long l2) {
        this.retentionPeriod = l2;
        return this;
    }

    public TSAlterParams chunkSize(long l2) {
        this.chunkSize = l2;
        return this;
    }

    public TSAlterParams duplicatePolicy(DuplicatePolicy duplicatePolicy) {
        this.duplicatePolicy = duplicatePolicy;
        return this;
    }

    public TSAlterParams labels(Map<String, String> map) {
        this.labels = map;
        return this;
    }

    public TSAlterParams label(String string, String string2) {
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        this.labels.put(string, string2);
        return this;
    }

    public TSAlterParams labelsReset() {
        return this.labels(Collections.emptyMap());
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.retentionPeriod != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.RETENTION).add(Protocol.toByteArray(this.retentionPeriod));
        }
        if (this.chunkSize != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.CHUNK_SIZE).add(Protocol.toByteArray(this.chunkSize));
        }
        if (this.duplicatePolicy != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.DUPLICATE_POLICY).add(this.duplicatePolicy);
        }
        if (this.labels != null) {
            commandArguments.add(TimeSeriesProtocol.TimeSeriesKeyword.LABELS);
            this.labels.entrySet().forEach(entry -> commandArguments.add(entry.getKey()).add(entry.getValue()));
        }
    }
}

