/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.schemafields;

import java.util.LinkedHashMap;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.search.FieldName;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;

public class VectorField
extends SchemaField {
    private final VectorAlgorithm algorithm;
    private final Map<String, Object> attributes;

    public VectorField(String string, VectorAlgorithm vectorAlgorithm, Map<String, Object> map) {
        super(string);
        this.algorithm = vectorAlgorithm;
        this.attributes = map;
    }

    public VectorField(FieldName fieldName, VectorAlgorithm vectorAlgorithm, Map<String, Object> map) {
        super(fieldName);
        this.algorithm = vectorAlgorithm;
        this.attributes = map;
    }

    @Override
    public VectorField as(String string) {
        super.as(string);
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        commandArguments.addParams(this.fieldName);
        commandArguments.add(SearchProtocol.SearchKeyword.VECTOR);
        commandArguments.add((Object)this.algorithm);
        commandArguments.add(this.attributes.size() * 2);
        this.attributes.forEach((string, object) -> commandArguments.add(string).add(object));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FieldName fieldName;
        private VectorAlgorithm algorithm;
        private Map<String, Object> attributes;

        private Builder() {
        }

        public VectorField build() {
            if (this.fieldName == null || this.algorithm == null || this.attributes == null || this.attributes.isEmpty()) {
                throw new IllegalArgumentException("All required VectorField parameters are not set.");
            }
            return new VectorField(this.fieldName, this.algorithm, this.attributes);
        }

        public Builder fieldName(String string) {
            this.fieldName = FieldName.of(string);
            return this;
        }

        public Builder fieldName(FieldName fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder as(String string) {
            this.fieldName.as(string);
            return this;
        }

        public Builder algorithm(VectorAlgorithm vectorAlgorithm) {
            this.algorithm = vectorAlgorithm;
            return this;
        }

        public Builder attributes(Map<String, Object> map) {
            this.attributes = map;
            return this;
        }

        public Builder addAttribute(String string, Object object) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(string, object);
            return this;
        }
    }

    public static enum VectorAlgorithm {
        FLAT,
        HNSW;

    }
}

