/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.schemafields;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.search.FieldName;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;

public class TextField
extends SchemaField {
    private boolean sortable;
    private boolean sortableUNF;
    private boolean noStem;
    private boolean noIndex;
    private String phoneticMatcher;
    private Double weight;
    private boolean withSuffixTrie;

    public TextField(String string) {
        super(string);
    }

    public TextField(FieldName fieldName) {
        super(fieldName);
    }

    public static TextField of(String string) {
        return new TextField(string);
    }

    public static TextField of(FieldName fieldName) {
        return new TextField(fieldName);
    }

    @Override
    public TextField as(String string) {
        super.as(string);
        return this;
    }

    public TextField sortable() {
        this.sortable = true;
        return this;
    }

    public TextField sortableUNF() {
        this.sortableUNF = true;
        return this;
    }

    public TextField sortableUnNormalizedForm() {
        return this.sortableUNF();
    }

    public TextField noStem() {
        this.noStem = true;
        return this;
    }

    public TextField noIndex() {
        this.noIndex = true;
        return this;
    }

    public TextField phonetic(String string) {
        this.phoneticMatcher = string;
        return this;
    }

    public TextField weight(double d2) {
        this.weight = d2;
        return this;
    }

    public TextField withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        commandArguments.addParams(this.fieldName);
        commandArguments.add(SearchProtocol.SearchKeyword.TEXT);
        if (this.sortableUNF) {
            commandArguments.add(SearchProtocol.SearchKeyword.SORTABLE).add(SearchProtocol.SearchKeyword.UNF);
        } else if (this.sortable) {
            commandArguments.add(SearchProtocol.SearchKeyword.SORTABLE);
        }
        if (this.noStem) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOSTEM);
        }
        if (this.noIndex) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
        if (this.phoneticMatcher != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.PHONETIC).add(this.phoneticMatcher);
        }
        if (this.weight != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.WEIGHT).add(this.weight);
        }
        if (this.withSuffixTrie) {
            commandArguments.add(SearchProtocol.SearchKeyword.WITHSUFFIXTRIE);
        }
    }
}

