/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.schemafields;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.search.FieldName;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class TagField
extends SchemaField {
    private boolean sortable;
    private boolean sortableUNF;
    private boolean noIndex;
    private byte[] separator;
    private boolean caseSensitive;
    private boolean withSuffixTrie;

    public TagField(String string) {
        super(string);
    }

    public TagField(FieldName fieldName) {
        super(fieldName);
    }

    public static TagField of(String string) {
        return new TagField(string);
    }

    public static TagField of(FieldName fieldName) {
        return new TagField(fieldName);
    }

    @Override
    public TagField as(String string) {
        super.as(string);
        return this;
    }

    public TagField sortable() {
        this.sortable = true;
        return this;
    }

    public TagField sortableUNF() {
        this.sortableUNF = true;
        return this;
    }

    public TagField sortableUnNormalizedForm() {
        return this.sortableUNF();
    }

    public TagField noIndex() {
        this.noIndex = true;
        return this;
    }

    public TagField separator(char c2) {
        this.separator = c2 < '\u0080' ? new byte[]{(byte)c2} : SafeEncoder.encode(String.valueOf(c2));
        return this;
    }

    public TagField caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public TagField withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        commandArguments.addParams(this.fieldName);
        commandArguments.add(SearchProtocol.SearchKeyword.TAG);
        if (this.separator != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SEPARATOR).add(this.separator);
        }
        if (this.sortableUNF) {
            commandArguments.add(SearchProtocol.SearchKeyword.SORTABLE).add(SearchProtocol.SearchKeyword.UNF);
        } else if (this.sortable) {
            commandArguments.add(SearchProtocol.SearchKeyword.SORTABLE);
        }
        if (this.noIndex) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
        if (this.caseSensitive) {
            commandArguments.add(SearchProtocol.SearchKeyword.CASESENSITIVE);
        }
        if (this.withSuffixTrie) {
            commandArguments.add(SearchProtocol.SearchKeyword.WITHSUFFIXTRIE);
        }
    }
}

