/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.querybuilder;

import java.util.StringJoiner;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.DoubleRangeValue;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.GeoValue;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.LongRangeValue;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.RangeValue;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Value;

public class Values {
    private Values() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Value value(final String string) {
        return new ScalableValue(){

            @Override
            public String toString() {
                return string;
            }
        };
    }

    public static GeoValue geo(GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return new GeoValue(geoCoordinate.getLongitude(), geoCoordinate.getLatitude(), d2, geoUnit);
    }

    public static RangeValue between(double d2, double d3) {
        return new DoubleRangeValue(d2, d3);
    }

    public static RangeValue between(int n2, int n3) {
        return new LongRangeValue(n2, n3);
    }

    public static RangeValue eq(double d2) {
        return new DoubleRangeValue(d2, d2);
    }

    public static RangeValue eq(int n2) {
        return new LongRangeValue(n2, n2);
    }

    public static RangeValue lt(double d2) {
        return new DoubleRangeValue(Double.NEGATIVE_INFINITY, d2).inclusiveMax(false);
    }

    public static RangeValue lt(int n2) {
        return new LongRangeValue(Long.MIN_VALUE, n2).inclusiveMax(false);
    }

    public static RangeValue gt(double d2) {
        return new DoubleRangeValue(d2, Double.POSITIVE_INFINITY).inclusiveMin(false);
    }

    public static RangeValue gt(int n2) {
        return new LongRangeValue(n2, Long.MAX_VALUE).inclusiveMin(false);
    }

    public static RangeValue le(double d2) {
        return Values.lt(d2).inclusiveMax(true);
    }

    public static RangeValue le(int n2) {
        return Values.lt(n2).inclusiveMax(true);
    }

    public static RangeValue ge(double d2) {
        return Values.gt(d2).inclusiveMin(true);
    }

    public static RangeValue ge(int n2) {
        return Values.gt(n2).inclusiveMin(true);
    }

    public static Value tags(String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Must have at least one tag");
        }
        final StringJoiner stringJoiner = new StringJoiner(" | ");
        for (String string : stringArray) {
            stringJoiner.add(string);
        }
        return new Value(){

            @Override
            public String toString() {
                return "{" + stringJoiner.toString() + "}";
            }
        };
    }

    private static abstract class ScalableValue
    extends Value {
        private ScalableValue() {
        }

        @Override
        public boolean isCombinable() {
            return true;
        }
    }
}

