/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.querybuilder;

import java.util.StringJoiner;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Node;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Value;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Values;

public class ValueNode
implements Node {
    private final Value[] values;
    private final String field;
    private final String joinString;

    public ValueNode(String string, String string2, Value ... valueArray) {
        this.field = string;
        this.values = valueArray;
        this.joinString = string2;
    }

    private static Value[] fromStrings(String[] stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            valueArray[i2] = Values.value(stringArray[i2]);
        }
        return valueArray;
    }

    public ValueNode(String string, String string2, String ... stringArray) {
        this(string, string2, ValueNode.fromStrings(stringArray));
    }

    private String formatField() {
        if (this.field == null || this.field.isEmpty()) {
            return "";
        }
        return '@' + this.field + ':';
    }

    private String toStringCombinable(Node.Parenthesize parenthesize) {
        StringBuilder stringBuilder = new StringBuilder(this.formatField());
        if (this.values.length > 1 || parenthesize == Node.Parenthesize.ALWAYS) {
            stringBuilder.append('(');
        }
        StringJoiner stringJoiner = new StringJoiner(this.joinString);
        for (Value value : this.values) {
            stringJoiner.add(value.toString());
        }
        stringBuilder.append(stringJoiner.toString());
        if (this.values.length > 1 || parenthesize == Node.Parenthesize.ALWAYS) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private String toStringDefault(Node.Parenthesize parenthesize) {
        boolean bl;
        boolean bl2 = bl = parenthesize == Node.Parenthesize.ALWAYS;
        if (!bl) {
            bl = parenthesize != Node.Parenthesize.NEVER && this.values.length > 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('(');
        }
        StringJoiner stringJoiner = new StringJoiner(this.joinString);
        for (Value value : this.values) {
            stringJoiner.add(this.formatField() + value.toString());
        }
        stringBuilder.append(stringJoiner.toString());
        if (bl) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(Node.Parenthesize parenthesize) {
        if (this.values[0].isCombinable()) {
            return this.toStringCombinable(parenthesize);
        }
        return this.toStringDefault(parenthesize);
    }
}

