/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Node;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Value;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.ValueNode;

public abstract class QueryNode
implements Node {
    private final List<Node> children = new ArrayList<Node>();

    protected abstract String getJoinString();

    public QueryNode add(String string, Value ... valueArray) {
        this.children.add(new ValueNode(string, this.getJoinString(), valueArray));
        return this;
    }

    public QueryNode add(String string, String ... stringArray) {
        this.children.add(new ValueNode(string, this.getJoinString(), stringArray));
        return this;
    }

    public QueryNode add(String string, Collection<Value> collection) {
        return this.add(string, collection.toArray(new Value[0]));
    }

    public QueryNode add(Node ... nodeArray) {
        this.children.addAll(Arrays.asList(nodeArray));
        return this;
    }

    protected boolean shouldParenthesize(Node.Parenthesize parenthesize) {
        if (parenthesize == Node.Parenthesize.ALWAYS) {
            return true;
        }
        if (parenthesize == Node.Parenthesize.NEVER) {
            return false;
        }
        return this.children.size() > 1;
    }

    @Override
    public String toString(Node.Parenthesize parenthesize) {
        StringBuilder stringBuilder = new StringBuilder();
        StringJoiner stringJoiner = new StringJoiner(this.getJoinString());
        if (this.shouldParenthesize(parenthesize)) {
            stringBuilder.append('(');
        }
        for (Node node : this.children) {
            stringJoiner.add(node.toString(parenthesize));
        }
        stringBuilder.append(stringJoiner.toString());
        if (this.shouldParenthesize(parenthesize)) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toString(Node.Parenthesize.DEFAULT);
    }
}

