/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.querybuilder;

import java.util.Arrays;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.DisjunctNode;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.DisjunctUnionNode;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.IntersectNode;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Node;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.OptionalNode;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.QueryNode;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.UnionNode;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Value;
import me.ulrich.clans.library.redis.jedis.search.querybuilder.Values;

public class QueryBuilders {
    private QueryBuilders() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static QueryNode intersect(Node ... nodeArray) {
        return new IntersectNode().add(nodeArray);
    }

    public static QueryNode intersect(String string, Value ... valueArray) {
        return new IntersectNode().add(string, valueArray);
    }

    public static QueryNode intersect(String string, String string2) {
        return QueryBuilders.intersect(string, Values.value(string2));
    }

    public static QueryNode union(Node ... nodeArray) {
        return new UnionNode().add(nodeArray);
    }

    public static QueryNode union(String string, Value ... valueArray) {
        return new UnionNode().add(string, valueArray);
    }

    public static QueryNode union(String string, String ... stringArray) {
        return QueryBuilders.union(string, (Value[])Arrays.stream(stringArray).map(Values::value).toArray());
    }

    public static QueryNode disjunct(Node ... nodeArray) {
        return new DisjunctNode().add(nodeArray);
    }

    public static QueryNode disjunct(String string, Value ... valueArray) {
        return new DisjunctNode().add(string, valueArray);
    }

    public static QueryNode disjunct(String string, String ... stringArray) {
        return QueryBuilders.disjunct(string, (Value[])Arrays.stream(stringArray).map(Values::value).toArray());
    }

    public static QueryNode disjunctUnion(Node ... nodeArray) {
        return new DisjunctUnionNode().add(nodeArray);
    }

    public static QueryNode disjunctUnion(String string, Value ... valueArray) {
        return new DisjunctUnionNode().add(string, valueArray);
    }

    public static QueryNode disjunctUnion(String string, String ... stringArray) {
        return QueryBuilders.disjunctUnion(string, (Value[])Arrays.stream(stringArray).map(Values::value).toArray());
    }

    public static QueryNode optional(Node ... nodeArray) {
        return new OptionalNode().add(nodeArray);
    }

    public static QueryNode optional(String string, Value ... valueArray) {
        return new OptionalNode().add(string, valueArray);
    }
}

