/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.aggr;

import java.util.List;
import me.ulrich.clans.library.redis.jedis.search.aggr.Reducer;
import me.ulrich.clans.library.redis.jedis.search.aggr.SortedField;

public class Reducers {
    public static Reducer count() {
        return new Reducer(){

            @Override
            public String getName() {
                return "COUNT";
            }
        };
    }

    private static Reducer singleFieldReducer(final String string, String string2) {
        return new Reducer(string2){

            @Override
            public String getName() {
                return string;
            }
        };
    }

    public static Reducer count_distinct(String string) {
        return Reducers.singleFieldReducer("COUNT_DISTINCT", string);
    }

    public static Reducer count_distinctish(String string) {
        return Reducers.singleFieldReducer("COUNT_DISTINCTISH", string);
    }

    public static Reducer sum(String string) {
        return Reducers.singleFieldReducer("SUM", string);
    }

    public static Reducer min(String string) {
        return Reducers.singleFieldReducer("MIN", string);
    }

    public static Reducer max(String string) {
        return Reducers.singleFieldReducer("MAX", string);
    }

    public static Reducer avg(String string) {
        return Reducers.singleFieldReducer("AVG", string);
    }

    public static Reducer stddev(String string) {
        return Reducers.singleFieldReducer("STDDEV", string);
    }

    public static Reducer quantile(String string, final double d2) {
        return new Reducer(string){

            @Override
            public String getName() {
                return "QUANTILE";
            }

            @Override
            protected List<String> getOwnArgs() {
                List<String> list = super.getOwnArgs();
                list.add(Double.toString(d2));
                return list;
            }
        };
    }

    public static Reducer first_value(String string, final SortedField sortedField) {
        return new Reducer(string){

            @Override
            public String getName() {
                return "FIRST_VALUE";
            }

            @Override
            protected List<String> getOwnArgs() {
                List<String> list = super.getOwnArgs();
                if (sortedField != null) {
                    list.add("BY");
                    list.add(sortedField.getField());
                    list.add(sortedField.getOrder());
                }
                return list;
            }
        };
    }

    public static Reducer first_value(String string) {
        return Reducers.first_value(string, null);
    }

    public static Reducer to_list(String string) {
        return Reducers.singleFieldReducer("TOLIST", string);
    }

    public static Reducer random_sample(String string, final int n2) {
        return new Reducer(string){

            @Override
            public String getName() {
                return "RANDOM_SAMPLE";
            }

            @Override
            protected List<String> getOwnArgs() {
                List<String> list = super.getOwnArgs();
                list.add(Integer.toString(n2));
                return list;
            }
        };
    }
}

