/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search.aggr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import me.ulrich.clans.library.redis.jedis.search.FieldName;
import me.ulrich.clans.library.redis.jedis.search.aggr.Group;
import me.ulrich.clans.library.redis.jedis.search.aggr.Limit;
import me.ulrich.clans.library.redis.jedis.search.aggr.Reducer;
import me.ulrich.clans.library.redis.jedis.search.aggr.SortedField;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class AggregationBuilder {
    private final List<String> args = new ArrayList<String>();
    private boolean isWithCursor = false;

    public AggregationBuilder(String string) {
        this.args.add(string);
    }

    public AggregationBuilder() {
        this("*");
    }

    public AggregationBuilder load(String ... stringArray) {
        return this.load(FieldName.convert(stringArray));
    }

    public AggregationBuilder load(FieldName ... fieldNameArray) {
        this.args.add("LOAD");
        int n2 = this.args.size();
        this.args.add(null);
        int n3 = 0;
        for (FieldName fieldName : fieldNameArray) {
            n3 += fieldName.addCommandEncodedArguments(this.args);
        }
        this.args.set(n2, Integer.toString(n3));
        return this;
    }

    public AggregationBuilder loadAll() {
        this.args.add("LOAD");
        this.args.add("*");
        return this;
    }

    public AggregationBuilder limit(int n2, int n3) {
        Limit limit = new Limit(n2, n3);
        limit.addArgs(this.args);
        return this;
    }

    public AggregationBuilder limit(int n2) {
        return this.limit(0, n2);
    }

    public AggregationBuilder sortBy(SortedField ... sortedFieldArray) {
        this.args.add("SORTBY");
        this.args.add(Integer.toString(sortedFieldArray.length * 2));
        for (SortedField sortedField : sortedFieldArray) {
            this.args.add(sortedField.getField());
            this.args.add(sortedField.getOrder());
        }
        return this;
    }

    public AggregationBuilder sortBy(int n2, SortedField ... sortedFieldArray) {
        this.sortBy(sortedFieldArray);
        if (n2 > 0) {
            this.args.add("MAX");
            this.args.add(Integer.toString(n2));
        }
        return this;
    }

    public AggregationBuilder sortByAsc(String string) {
        return this.sortBy(SortedField.asc(string));
    }

    public AggregationBuilder sortByDesc(String string) {
        return this.sortBy(SortedField.desc(string));
    }

    public AggregationBuilder apply(String string, String string2) {
        this.args.add("APPLY");
        this.args.add(string);
        this.args.add("AS");
        this.args.add(string2);
        return this;
    }

    public AggregationBuilder groupBy(Collection<String> collection, Collection<Reducer> collection2) {
        String[] stringArray = new String[collection.size()];
        Group group = new Group(collection.toArray(stringArray));
        for (Reducer reducer : collection2) {
            group.reduce(reducer);
        }
        this.groupBy(group);
        return this;
    }

    public AggregationBuilder groupBy(String string, Reducer ... reducerArray) {
        return this.groupBy(Collections.singletonList(string), Arrays.asList(reducerArray));
    }

    public AggregationBuilder groupBy(Group group) {
        this.args.add("GROUPBY");
        group.addArgs(this.args);
        return this;
    }

    public AggregationBuilder filter(String string) {
        this.args.add("FILTER");
        this.args.add(string);
        return this;
    }

    public AggregationBuilder cursor(int n2, long l2) {
        this.isWithCursor = true;
        if (n2 > 0) {
            this.args.add("WITHCURSOR");
            this.args.add("COUNT");
            this.args.add(Integer.toString(n2));
            if (l2 < Long.MAX_VALUE && l2 >= 0L) {
                this.args.add("MAXIDLE");
                this.args.add(Long.toString(l2));
            }
        }
        return this;
    }

    public AggregationBuilder verbatim() {
        this.args.add("VERBATIM");
        return this;
    }

    public AggregationBuilder timeout(long l2) {
        if (l2 >= 0L) {
            this.args.add("TIMEOUT");
            this.args.add(Long.toString(l2));
        }
        return this;
    }

    public AggregationBuilder params(Map<String, Object> map) {
        if (map.size() >= 1) {
            this.args.add("PARAMS");
            this.args.add(Integer.toString(map.size() * 2));
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.args.add(entry.getKey());
                this.args.add(String.valueOf(entry.getValue()));
            }
        }
        return this;
    }

    public AggregationBuilder dialect(int n2) {
        this.args.add("DIALECT");
        this.args.add(Integer.toString(n2));
        return this;
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public void serializeRedisArgs(List<byte[]> list) {
        for (String string : this.getArgs()) {
            list.add(SafeEncoder.encode(string));
        }
    }

    public String getArgsString() {
        StringJoiner stringJoiner = new StringJoiner(" ");
        for (String string : this.getArgs()) {
            stringJoiner.add(string);
        }
        return stringJoiner.toString();
    }

    public boolean isWithCursor() {
        return this.isWithCursor;
    }
}

