/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.ArrayList;
import java.util.List;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.search.Document;

public class SearchResult {
    private final long totalResults;
    private final List<Document> documents;

    private SearchResult(long l2, List<Document> list) {
        this.totalResults = l2;
        this.documents = list;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public static class SearchResultBuilder
    extends Builder<SearchResult> {
        private final boolean hasContent;
        private final boolean hasScores;
        private final boolean hasPayloads;
        private final boolean decode;

        public SearchResultBuilder(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.hasContent = bl;
            this.hasScores = bl2;
            this.hasPayloads = bl3;
            this.decode = bl4;
        }

        @Override
        public SearchResult build(Object object) {
            List list = (List)object;
            int n2 = 1;
            int n3 = 0;
            int n4 = 1;
            int n5 = 0;
            if (this.hasScores) {
                ++n2;
                n3 = 1;
                ++n4;
            }
            if (this.hasContent) {
                ++n2;
                if (this.hasPayloads) {
                    n5 = n3 + 1;
                    ++n2;
                    ++n4;
                }
            }
            long l2 = (Long)list.get(0);
            ArrayList<Document> arrayList = new ArrayList<Document>(list.size() - 1);
            for (int i2 = 1; i2 < list.size(); i2 += n2) {
                String string = BuilderFactory.STRING.build(list.get(i2));
                double d2 = this.hasScores ? BuilderFactory.DOUBLE.build(list.get(i2 + n3)) : 1.0;
                byte[] byArray = this.hasPayloads ? (byte[])list.get(i2 + n5) : null;
                List list2 = this.hasContent ? (List)list.get(i2 + n4) : null;
                arrayList.add(Document.load(string, d2, byArray, list2, this.decode));
            }
            return new SearchResult(l2, arrayList);
        }
    }
}

