/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.search.FieldName;

public class Schema {
    @Deprecated
    public final List<Field> fields = new ArrayList<Field>();

    public static Schema from(Field ... fieldArray) {
        Schema schema = new Schema();
        for (Field field : fieldArray) {
            schema.addField(field);
        }
        return schema;
    }

    public Schema addTextField(String string, double d2) {
        this.fields.add(new TextField(string, d2));
        return this;
    }

    public Schema addSortableTextField(String string, double d2) {
        this.fields.add(new TextField(string, d2, true));
        return this;
    }

    public Schema addGeoField(String string) {
        this.fields.add(new Field(string, FieldType.GEO, false));
        return this;
    }

    public Schema addNumericField(String string) {
        this.fields.add(new Field(string, FieldType.NUMERIC, false));
        return this;
    }

    public Schema addSortableNumericField(String string) {
        this.fields.add(new Field(string, FieldType.NUMERIC, true));
        return this;
    }

    public Schema addTagField(String string) {
        this.fields.add(new TagField(string));
        return this;
    }

    public Schema addTagField(String string, String string2) {
        this.fields.add(new TagField(string, string2));
        return this;
    }

    public Schema addTagField(String string, boolean bl) {
        this.fields.add(new TagField(string, bl, false));
        return this;
    }

    public Schema addTagField(String string, String string2, boolean bl) {
        this.fields.add(new TagField(string, string2, bl, false));
        return this;
    }

    public Schema addSortableTagField(String string, String string2) {
        this.fields.add(new TagField(string, string2, true));
        return this;
    }

    public Schema addSortableTagField(String string, boolean bl) {
        this.fields.add(new TagField(string, bl, true));
        return this;
    }

    public Schema addSortableTagField(String string, String string2, boolean bl) {
        this.fields.add(new TagField(string, string2, bl, true));
        return this;
    }

    public Schema addVectorField(String string, VectorField.VectorAlgo vectorAlgo, Map<String, Object> map) {
        this.fields.add(new VectorField(string, vectorAlgo, map));
        return this;
    }

    public Schema addFlatVectorField(String string, Map<String, Object> map) {
        this.fields.add(new VectorField(string, VectorField.VectorAlgo.FLAT, map));
        return this;
    }

    public Schema addHNSWVectorField(String string, Map<String, Object> map) {
        this.fields.add(new VectorField(string, VectorField.VectorAlgo.HNSW, map));
        return this;
    }

    public Schema addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public Schema as(String string) {
        this.fields.get(this.fields.size() - 1).as(string);
        return this;
    }

    public String toString() {
        return "Schema{fields=" + this.fields + "}";
    }

    public static class VectorField
    extends Field {
        private final VectorAlgo algorithm;
        private final Map<String, Object> attributes;

        public VectorField(String string, VectorAlgo vectorAlgo, Map<String, Object> map) {
            super(string, FieldType.VECTOR);
            this.algorithm = vectorAlgo;
            this.attributes = map;
        }

        @Override
        public void addTypeArgs(CommandArguments commandArguments) {
            commandArguments.add((Object)this.algorithm);
            commandArguments.add(this.attributes.size() * 2);
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                commandArguments.add(entry.getKey());
                commandArguments.add(entry.getValue());
            }
        }

        @Override
        public String toString() {
            return "VectorField{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", algorithm=" + (Object)((Object)this.algorithm) + ", attributes=" + this.attributes + "}";
        }

        public static enum VectorAlgo {
            FLAT,
            HNSW;

        }
    }

    public static class TagField
    extends Field {
        private final String separator;
        private final boolean caseSensitive;

        public TagField(String string) {
            this(string, (String)null);
        }

        public TagField(String string, String string2) {
            this(string, string2, false);
        }

        public TagField(String string, boolean bl) {
            this(string, (String)null, bl);
        }

        public TagField(String string, String string2, boolean bl) {
            this(string, string2, false, bl);
        }

        public TagField(String string, boolean bl, boolean bl2) {
            this(string, (String)null, bl, bl2);
        }

        public TagField(String string, String string2, boolean bl, boolean bl2) {
            super(string, FieldType.TAG, bl2);
            this.separator = string2;
            this.caseSensitive = bl;
        }

        public TagField(FieldName fieldName, String string, boolean bl) {
            this(fieldName, string, false, bl);
        }

        public TagField(FieldName fieldName, String string, boolean bl, boolean bl2) {
            super(fieldName, FieldType.TAG, bl2, false);
            this.separator = string;
            this.caseSensitive = bl;
        }

        @Override
        public void addTypeArgs(CommandArguments commandArguments) {
            if (this.separator != null) {
                commandArguments.add("SEPARATOR");
                commandArguments.add(this.separator);
            }
            if (this.caseSensitive) {
                commandArguments.add("CASESENSITIVE");
            }
        }

        @Override
        public String toString() {
            return "TagField{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noIndex + ", separator='" + this.separator + ", caseSensitive='" + this.caseSensitive + "'}";
        }
    }

    public static class TextField
    extends Field {
        private final double weight;
        private final boolean nostem;
        private final String phonetic;

        public TextField(String string) {
            this(string, 1.0);
        }

        public TextField(FieldName fieldName) {
            this(fieldName, 1.0, false, false, false, null);
        }

        public TextField(String string, double d2) {
            this(string, d2, false);
        }

        public TextField(String string, double d2, boolean bl) {
            this(string, d2, bl, false);
        }

        public TextField(String string, double d2, boolean bl, boolean bl2) {
            this(string, d2, bl, bl2, false);
        }

        public TextField(String string, double d2, boolean bl, boolean bl2, boolean bl3) {
            this(string, d2, bl, bl2, bl3, null);
        }

        public TextField(String string, double d2, boolean bl, boolean bl2, boolean bl3, String string2) {
            super(string, FieldType.TEXT, bl, bl3);
            this.weight = d2;
            this.nostem = bl2;
            this.phonetic = string2;
        }

        public TextField(FieldName fieldName, double d2, boolean bl, boolean bl2, boolean bl3, String string) {
            super(fieldName, FieldType.TEXT, bl, bl3);
            this.weight = d2;
            this.nostem = bl2;
            this.phonetic = string;
        }

        @Override
        protected void addTypeArgs(CommandArguments commandArguments) {
            if (this.weight != 1.0) {
                commandArguments.add("WEIGHT");
                commandArguments.add(Double.toString(this.weight));
            }
            if (this.nostem) {
                commandArguments.add("NOSTEM");
            }
            if (this.phonetic != null) {
                commandArguments.add("PHONETIC");
                commandArguments.add(this.phonetic);
            }
        }

        @Override
        public String toString() {
            return "TextField{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noIndex + ", weight=" + this.weight + ", nostem=" + this.nostem + ", phonetic='" + this.phonetic + "'}";
        }
    }

    public static class Field
    implements IParams {
        protected final FieldName fieldName;
        @Deprecated
        public final String name;
        @Deprecated
        public final FieldType type;
        @Deprecated
        public final boolean sortable;
        @Deprecated
        public final boolean noIndex;

        public Field(String string, FieldType fieldType) {
            this(string, fieldType, false, false);
        }

        public Field(String string, FieldType fieldType, boolean bl) {
            this(string, fieldType, bl, false);
        }

        public Field(String string, FieldType fieldType, boolean bl, boolean bl2) {
            this(FieldName.of(string), fieldType, bl, bl2);
        }

        public Field(FieldName fieldName, FieldType fieldType) {
            this(fieldName, fieldType, false, false);
        }

        public Field(FieldName fieldName, FieldType fieldType, boolean bl, boolean bl2) {
            this.fieldName = fieldName;
            this.name = this.fieldName.getName();
            this.type = fieldType;
            this.sortable = bl;
            this.noIndex = bl2;
        }

        public void as(String string) {
            this.fieldName.as(string);
        }

        @Override
        public final void addParams(CommandArguments commandArguments) {
            this.fieldName.addParams(commandArguments);
            commandArguments.add(this.type.name());
            this.addTypeArgs(commandArguments);
            if (this.sortable) {
                commandArguments.add("SORTABLE");
            }
            if (this.noIndex) {
                commandArguments.add("NOINDEX");
            }
        }

        protected void addTypeArgs(CommandArguments commandArguments) {
        }

        public String toString() {
            return "Field{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noIndex + "}";
        }
    }

    public static enum FieldType {
        TAG,
        TEXT,
        GEO,
        NUMERIC,
        VECTOR;

    }
}

