/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.Response;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.search.FTCreateParams;
import me.ulrich.clans.library.redis.jedis.search.FTSearchParams;
import me.ulrich.clans.library.redis.jedis.search.IndexOptions;
import me.ulrich.clans.library.redis.jedis.search.Query;
import me.ulrich.clans.library.redis.jedis.search.Schema;
import me.ulrich.clans.library.redis.jedis.search.SearchResult;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationBuilder;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;

public interface RediSearchPipelineCommands {
    public Response<String> ftCreate(String var1, IndexOptions var2, Schema var3);

    default public Response<String> ftCreate(String string, SchemaField ... schemaFieldArray) {
        return this.ftCreate(string, Arrays.asList(schemaFieldArray));
    }

    default public Response<String> ftCreate(String string, FTCreateParams fTCreateParams, SchemaField ... schemaFieldArray) {
        return this.ftCreate(string, fTCreateParams, Arrays.asList(schemaFieldArray));
    }

    default public Response<String> ftCreate(String string, Iterable<SchemaField> iterable) {
        return this.ftCreate(string, FTCreateParams.createParams(), iterable);
    }

    public Response<String> ftCreate(String var1, FTCreateParams var2, Iterable<SchemaField> var3);

    default public Response<String> ftAlter(String string, Schema.Field ... fieldArray) {
        return this.ftAlter(string, Schema.from(fieldArray));
    }

    public Response<String> ftAlter(String var1, Schema var2);

    default public Response<String> ftAlter(String string, SchemaField ... schemaFieldArray) {
        return this.ftAlter(string, Arrays.asList(schemaFieldArray));
    }

    public Response<String> ftAlter(String var1, Iterable<SchemaField> var2);

    default public Response<SearchResult> ftSearch(String string) {
        return this.ftSearch(string, "*");
    }

    public Response<SearchResult> ftSearch(String var1, String var2);

    public Response<SearchResult> ftSearch(String var1, String var2, FTSearchParams var3);

    public Response<SearchResult> ftSearch(String var1, Query var2);

    public Response<SearchResult> ftSearch(byte[] var1, Query var2);

    public Response<String> ftExplain(String var1, Query var2);

    public Response<List<String>> ftExplainCLI(String var1, Query var2);

    public Response<AggregationResult> ftAggregate(String var1, AggregationBuilder var2);

    public Response<AggregationResult> ftCursorRead(String var1, long var2, int var4);

    public Response<String> ftCursorDel(String var1, long var2);

    public Response<String> ftDropIndex(String var1);

    public Response<String> ftDropIndexDD(String var1);

    public Response<String> ftSynUpdate(String var1, String var2, String ... var3);

    public Response<Map<String, List<String>>> ftSynDump(String var1);

    public Response<Long> ftDictAdd(String var1, String ... var2);

    public Response<Long> ftDictDel(String var1, String ... var2);

    public Response<Set<String>> ftDictDump(String var1);

    public Response<Long> ftDictAddBySampleKey(String var1, String var2, String ... var3);

    public Response<Long> ftDictDelBySampleKey(String var1, String var2, String ... var3);

    public Response<Set<String>> ftDictDumpBySampleKey(String var1, String var2);

    public Response<Map<String, Object>> ftInfo(String var1);

    public Response<Set<String>> ftTagVals(String var1, String var2);

    public Response<String> ftAliasAdd(String var1, String var2);

    public Response<String> ftAliasUpdate(String var1, String var2);

    public Response<String> ftAliasDel(String var1);

    public Response<Map<String, String>> ftConfigGet(String var1);

    public Response<Map<String, String>> ftConfigGet(String var1, String var2);

    public Response<String> ftConfigSet(String var1, String var2);

    public Response<String> ftConfigSet(String var1, String var2, String var3);

    public Response<Long> ftSugAdd(String var1, String var2, double var3);

    public Response<Long> ftSugAddIncr(String var1, String var2, double var3);

    public Response<List<String>> ftSugGet(String var1, String var2);

    public Response<List<String>> ftSugGet(String var1, String var2, boolean var3, int var4);

    public Response<List<Tuple>> ftSugGetWithScores(String var1, String var2);

    public Response<List<Tuple>> ftSugGetWithScores(String var1, String var2, boolean var3, int var4);

    public Response<Boolean> ftSugDel(String var1, String var2);

    public Response<Long> ftSugLen(String var1);
}

