/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.search.FTCreateParams;
import me.ulrich.clans.library.redis.jedis.search.FTSearchParams;
import me.ulrich.clans.library.redis.jedis.search.IndexOptions;
import me.ulrich.clans.library.redis.jedis.search.Query;
import me.ulrich.clans.library.redis.jedis.search.Schema;
import me.ulrich.clans.library.redis.jedis.search.SearchResult;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationBuilder;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;

public interface RediSearchCommands {
    public String ftCreate(String var1, IndexOptions var2, Schema var3);

    default public String ftCreate(String string, SchemaField ... schemaFieldArray) {
        return this.ftCreate(string, Arrays.asList(schemaFieldArray));
    }

    default public String ftCreate(String string, FTCreateParams fTCreateParams, SchemaField ... schemaFieldArray) {
        return this.ftCreate(string, fTCreateParams, Arrays.asList(schemaFieldArray));
    }

    default public String ftCreate(String string, Iterable<SchemaField> iterable) {
        return this.ftCreate(string, FTCreateParams.createParams(), iterable);
    }

    public String ftCreate(String var1, FTCreateParams var2, Iterable<SchemaField> var3);

    default public String ftAlter(String string, Schema.Field ... fieldArray) {
        return this.ftAlter(string, Schema.from(fieldArray));
    }

    public String ftAlter(String var1, Schema var2);

    default public String ftAlter(String string, SchemaField ... schemaFieldArray) {
        return this.ftAlter(string, Arrays.asList(schemaFieldArray));
    }

    public String ftAlter(String var1, Iterable<SchemaField> var2);

    default public SearchResult ftSearch(String string) {
        return this.ftSearch(string, "*");
    }

    public SearchResult ftSearch(String var1, String var2);

    public SearchResult ftSearch(String var1, String var2, FTSearchParams var3);

    public SearchResult ftSearch(String var1, Query var2);

    public SearchResult ftSearch(byte[] var1, Query var2);

    public String ftExplain(String var1, Query var2);

    public List<String> ftExplainCLI(String var1, Query var2);

    public AggregationResult ftAggregate(String var1, AggregationBuilder var2);

    public AggregationResult ftCursorRead(String var1, long var2, int var4);

    public String ftCursorDel(String var1, long var2);

    public String ftDropIndex(String var1);

    public String ftDropIndexDD(String var1);

    public String ftSynUpdate(String var1, String var2, String ... var3);

    public Map<String, List<String>> ftSynDump(String var1);

    public long ftDictAdd(String var1, String ... var2);

    public long ftDictDel(String var1, String ... var2);

    public Set<String> ftDictDump(String var1);

    public long ftDictAddBySampleKey(String var1, String var2, String ... var3);

    public long ftDictDelBySampleKey(String var1, String var2, String ... var3);

    public Set<String> ftDictDumpBySampleKey(String var1, String var2);

    public Map<String, Object> ftInfo(String var1);

    public Set<String> ftTagVals(String var1, String var2);

    public String ftAliasAdd(String var1, String var2);

    public String ftAliasUpdate(String var1, String var2);

    public String ftAliasDel(String var1);

    public Map<String, String> ftConfigGet(String var1);

    public Map<String, String> ftConfigGet(String var1, String var2);

    public String ftConfigSet(String var1, String var2);

    public String ftConfigSet(String var1, String var2, String var3);

    public long ftSugAdd(String var1, String var2, double var3);

    public long ftSugAddIncr(String var1, String var2, double var3);

    public List<String> ftSugGet(String var1, String var2);

    public List<String> ftSugGet(String var1, String var2, boolean var3, int var4);

    public List<Tuple> ftSugGetWithScores(String var1, String var2);

    public List<Tuple> ftSugGetWithScores(String var1, String var2, boolean var3, int var4);

    public boolean ftSugDel(String var1, String var2);

    public long ftSugLen(String var1);
}

