/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.search.FieldName;
import me.ulrich.clans.library.redis.jedis.search.LazyRawable;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class Query
implements IParams {
    private final List<Filter> _filters = new LinkedList<Filter>();
    private final String _queryString;
    private final Paging _paging = new Paging(0, 10);
    private boolean _verbatim = false;
    private boolean _noContent = false;
    private boolean _noStopwords = false;
    private boolean _withScores = false;
    private boolean _withPayloads = false;
    private String _language = null;
    private String[] _fields = null;
    private String[] _keys = null;
    private String[] _returnFields = null;
    private FieldName[] returnFieldNames = null;
    private String[] highlightFields = null;
    private String[] summarizeFields = null;
    private String[] highlightTags = null;
    private String summarizeSeparator = null;
    private int summarizeNumFragments = -1;
    private int summarizeFragmentLen = -1;
    private byte[] _payload = null;
    private String _sortBy = null;
    private boolean _sortAsc = true;
    private boolean wantsHighlight = false;
    private boolean wantsSummarize = false;
    private String _scorer = null;
    private Map<String, Object> _params = null;
    private int _dialect = 0;
    private int _slop = -1;
    private long _timeout = -1L;
    private boolean _inOrder = false;
    private String _expander = null;

    public Query() {
        this("*");
    }

    public Query(String string) {
        this._queryString = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addParams(CommandArguments commandArguments) {
        commandArguments.add(SafeEncoder.encode(this._queryString));
        if (this._verbatim) {
            commandArguments.add(SearchProtocol.SearchKeyword.VERBATIM.getRaw());
        }
        if (this._noContent) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOCONTENT.getRaw());
        }
        if (this._noStopwords) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOSTOPWORDS.getRaw());
        }
        if (this._withScores) {
            commandArguments.add(SearchProtocol.SearchKeyword.WITHSCORES.getRaw());
        }
        if (this._withPayloads) {
            commandArguments.add(SearchProtocol.SearchKeyword.WITHPAYLOADS.getRaw());
        }
        if (this._language != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LANGUAGE.getRaw());
            commandArguments.add(SafeEncoder.encode(this._language));
        }
        if (this._scorer != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SCORER.getRaw());
            commandArguments.add(SafeEncoder.encode(this._scorer));
        }
        if (this._fields != null && this._fields.length > 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.INFIELDS.getRaw());
            commandArguments.add(Protocol.toByteArray(this._fields.length));
            for (String string : this._fields) {
                commandArguments.add(SafeEncoder.encode(string));
            }
        }
        if (this._sortBy != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SORTBY.getRaw());
            commandArguments.add(SafeEncoder.encode(this._sortBy));
            commandArguments.add((this._sortAsc ? SearchProtocol.SearchKeyword.ASC : SearchProtocol.SearchKeyword.DESC).getRaw());
        }
        if (this._payload != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.PAYLOAD.getRaw());
            commandArguments.add(this._payload);
        }
        if (this._paging.offset != 0 || this._paging.num != 10) {
            commandArguments.add(SearchProtocol.SearchKeyword.LIMIT.getRaw()).add(Protocol.toByteArray(this._paging.offset)).add(Protocol.toByteArray(this._paging.num));
        }
        if (!this._filters.isEmpty()) {
            this._filters.forEach(filter -> filter.addParams(commandArguments));
        }
        if (this.wantsHighlight) {
            commandArguments.add(SearchProtocol.SearchKeyword.HIGHLIGHT.getRaw());
            if (this.highlightFields != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.FIELDS.getRaw());
                commandArguments.add(Protocol.toByteArray(this.highlightFields.length));
                for (String string : this.highlightFields) {
                    commandArguments.add(SafeEncoder.encode(string));
                }
            }
            if (this.highlightTags != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.TAGS.getRaw());
                for (String string : this.highlightTags) {
                    commandArguments.add(SafeEncoder.encode(string));
                }
            }
        }
        if (this.wantsSummarize) {
            commandArguments.add(SearchProtocol.SearchKeyword.SUMMARIZE.getRaw());
            if (this.summarizeFields != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.FIELDS.getRaw());
                commandArguments.add(Protocol.toByteArray(this.summarizeFields.length));
                for (String string : this.summarizeFields) {
                    commandArguments.add(SafeEncoder.encode(string));
                }
            }
            if (this.summarizeNumFragments != -1) {
                commandArguments.add(SearchProtocol.SearchKeyword.FRAGS.getRaw());
                commandArguments.add(Protocol.toByteArray(this.summarizeNumFragments));
            }
            if (this.summarizeFragmentLen != -1) {
                commandArguments.add(SearchProtocol.SearchKeyword.LEN.getRaw());
                commandArguments.add(Protocol.toByteArray(this.summarizeFragmentLen));
            }
            if (this.summarizeSeparator != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.SEPARATOR.getRaw());
                commandArguments.add(SafeEncoder.encode(this.summarizeSeparator));
            }
        }
        if (this._keys != null && this._keys.length > 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.INKEYS.getRaw());
            commandArguments.add(Protocol.toByteArray(this._keys.length));
            for (String string : this._keys) {
                commandArguments.add(SafeEncoder.encode(string));
            }
        }
        if (this._returnFields != null && this._returnFields.length > 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.RETURN.getRaw());
            commandArguments.add(Protocol.toByteArray(this._returnFields.length));
            for (String string : this._returnFields) {
                commandArguments.add(SafeEncoder.encode(string));
            }
        } else if (this.returnFieldNames != null && this.returnFieldNames.length > 0) {
            void var3_10;
            commandArguments.add(SearchProtocol.SearchKeyword.RETURN.getRaw());
            LazyRawable lazyRawable = new LazyRawable();
            commandArguments.add(lazyRawable);
            boolean bl = false;
            for (FieldName fieldName : this.returnFieldNames) {
                var3_10 += fieldName.addCommandArguments(commandArguments);
            }
            lazyRawable.setRaw(Protocol.toByteArray((int)var3_10));
        }
        if (this._params != null && this._params.size() > 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.PARAMS.getRaw());
            commandArguments.add(this._params.size() * 2);
            for (Map.Entry entry : this._params.entrySet()) {
                commandArguments.add(entry.getKey());
                commandArguments.add(entry.getValue());
            }
        }
        if (this._dialect != 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.DIALECT.getRaw());
            commandArguments.add(this._dialect);
        }
        if (this._slop >= 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.SLOP.getRaw());
            commandArguments.add(this._slop);
        }
        if (this._timeout >= 0L) {
            commandArguments.add(SearchProtocol.SearchKeyword.TIMEOUT.getRaw());
            commandArguments.add(this._timeout);
        }
        if (this._inOrder) {
            commandArguments.add(SearchProtocol.SearchKeyword.INORDER.getRaw());
        }
        if (this._expander != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.EXPANDER.getRaw());
            commandArguments.add(SafeEncoder.encode(this._expander));
        }
    }

    public Query limit(Integer n2, Integer n3) {
        this._paging.offset = n2;
        this._paging.num = n3;
        return this;
    }

    public Query addFilter(Filter filter) {
        this._filters.add(filter);
        return this;
    }

    @Deprecated
    public Query setPayload(byte[] byArray) {
        this._payload = byArray;
        return this;
    }

    public Query setVerbatim() {
        this._verbatim = true;
        return this;
    }

    public boolean getNoContent() {
        return this._noContent;
    }

    public Query setNoContent() {
        this._noContent = true;
        return this;
    }

    public Query setNoStopwords() {
        this._noStopwords = true;
        return this;
    }

    public boolean getWithScores() {
        return this._withScores;
    }

    public Query setWithScores() {
        this._withScores = true;
        return this;
    }

    public boolean getWithPayloads() {
        return this._withPayloads;
    }

    @Deprecated
    public Query setWithPayload() {
        this._withPayloads = true;
        return this;
    }

    public Query setLanguage(String string) {
        this._language = string;
        return this;
    }

    public Query setScorer(String string) {
        this._scorer = string;
        return this;
    }

    public Query limitFields(String ... stringArray) {
        this._fields = stringArray;
        return this;
    }

    public Query limitKeys(String ... stringArray) {
        this._keys = stringArray;
        return this;
    }

    public Query returnFields(String ... stringArray) {
        this._returnFields = stringArray;
        this.returnFieldNames = null;
        return this;
    }

    public Query returnFields(FieldName ... fieldNameArray) {
        this.returnFieldNames = fieldNameArray;
        this._returnFields = null;
        return this;
    }

    public Query highlightFields(HighlightTags highlightTags, String ... stringArray) {
        if (stringArray == null || stringArray.length > 0) {
            this.highlightFields = stringArray;
        }
        this.highlightTags = highlightTags != null ? new String[]{highlightTags.open, highlightTags.close} : null;
        this.wantsHighlight = true;
        return this;
    }

    public Query highlightFields(String ... stringArray) {
        return this.highlightFields((HighlightTags)null, stringArray);
    }

    public Query summarizeFields(int n2, int n3, String string, String ... stringArray) {
        if (stringArray == null || stringArray.length > 0) {
            this.summarizeFields = stringArray;
        }
        this.summarizeFragmentLen = n2;
        this.summarizeNumFragments = n3;
        this.summarizeSeparator = string;
        this.wantsSummarize = true;
        return this;
    }

    public Query summarizeFields(String ... stringArray) {
        return this.summarizeFields(-1, -1, null, stringArray);
    }

    public Query setSortBy(String string, boolean bl) {
        this._sortBy = string;
        this._sortAsc = bl;
        return this;
    }

    public Query addParam(String string, Object object) {
        if (this._params == null) {
            this._params = new HashMap<String, Object>();
        }
        this._params.put(string, object);
        return this;
    }

    public Query dialect(int n2) {
        this._dialect = n2;
        return this;
    }

    public Query slop(int n2) {
        this._slop = n2;
        return this;
    }

    public Query timeout(long l2) {
        this._timeout = l2;
        return this;
    }

    public Query setInOrder() {
        this._inOrder = true;
        return this;
    }

    public Query setExpander(String string) {
        this._expander = string;
        return this;
    }

    public static class HighlightTags {
        private final String open;
        private final String close;

        public HighlightTags(String string, String string2) {
            this.open = string;
            this.close = string2;
        }
    }

    public static class Paging {
        int offset;
        int num;

        public Paging(int n2, int n3) {
            this.offset = n2;
            this.num = n3;
        }
    }

    public static class GeoFilter
    extends Filter {
        public static final String KILOMETERS = "km";
        public static final String METERS = "m";
        public static final String FEET = "ft";
        public static final String MILES = "mi";
        private final double lon;
        private final double lat;
        private final double radius;
        private final String unit;

        public GeoFilter(String string, double d2, double d3, double d4, String string2) {
            super(string);
            this.lon = d2;
            this.lat = d3;
            this.radius = d4;
            this.unit = string2;
        }

        @Override
        public void addParams(CommandArguments commandArguments) {
            commandArguments.add(SearchProtocol.SearchKeyword.GEOFILTER.getRaw());
            commandArguments.add(SafeEncoder.encode(this.property));
            commandArguments.add(Protocol.toByteArray(this.lon));
            commandArguments.add(Protocol.toByteArray(this.lat));
            commandArguments.add(Protocol.toByteArray(this.radius));
            commandArguments.add(SafeEncoder.encode(this.unit));
        }
    }

    public static class NumericFilter
    extends Filter {
        private final double min;
        private final boolean exclusiveMin;
        private final double max;
        private final boolean exclusiveMax;

        public NumericFilter(String string, double d2, boolean bl, double d3, boolean bl2) {
            super(string);
            this.min = d2;
            this.max = d3;
            this.exclusiveMax = bl2;
            this.exclusiveMin = bl;
        }

        public NumericFilter(String string, double d2, double d3) {
            this(string, d2, false, d3, false);
        }

        private byte[] formatNum(double d2, boolean bl) {
            return bl ? SafeEncoder.encode("(" + d2) : Protocol.toByteArray(d2);
        }

        @Override
        public void addParams(CommandArguments commandArguments) {
            commandArguments.add(SearchProtocol.SearchKeyword.FILTER.getRaw());
            commandArguments.add(SafeEncoder.encode(this.property));
            commandArguments.add(this.formatNum(this.min, this.exclusiveMin));
            commandArguments.add(this.formatNum(this.max, this.exclusiveMax));
        }
    }

    public static abstract class Filter
    implements IParams {
        public final String property;

        public Filter(String string) {
            this.property = string;
        }
    }
}

