/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.search.IndexDefinition;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;

public class IndexOptions
implements IParams {
    public static final int USE_TERM_OFFSETS = 1;
    public static final int KEEP_FIELD_FLAGS = 2;
    public static final int KEEP_TERM_FREQUENCIES = 8;
    public static final int DEFAULT_FLAGS = 11;
    private final int flags;
    private List<String> stopwords;
    private long expire = 0L;
    private IndexDefinition definition;

    public IndexOptions(int n2) {
        this.flags = n2;
    }

    public static IndexOptions defaultOptions() {
        return new IndexOptions(11);
    }

    public IndexOptions setStopwords(String ... stringArray) {
        this.stopwords = Arrays.asList(stringArray);
        return this;
    }

    public IndexOptions setNoStopwords() {
        this.stopwords = new ArrayList<String>(0);
        return this;
    }

    public IndexOptions setTemporary(long l2) {
        this.expire = l2;
        return this;
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    public IndexOptions setDefinition(IndexDefinition indexDefinition) {
        this.definition = indexDefinition;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.definition != null) {
            this.definition.addParams(commandArguments);
        }
        if ((this.flags & 1) == 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOOFFSETS.name());
        }
        if ((this.flags & 2) == 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOFIELDS.name());
        }
        if ((this.flags & 8) == 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOFREQS.name());
        }
        if (this.expire > 0L) {
            commandArguments.add(SearchProtocol.SearchKeyword.TEMPORARY.name());
            commandArguments.add(Long.toString(this.expire));
        }
        if (this.stopwords != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.STOPWORDS.name());
            commandArguments.add(Integer.toString(this.stopwords.size()));
            if (!this.stopwords.isEmpty()) {
                commandArguments.addObjects(this.stopwords);
            }
        }
    }
}

