/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;

public class IndexDefinition
implements IParams {
    private final Type type;
    private boolean async = false;
    private String[] prefixes;
    private String filter;
    private String languageField;
    private String language;
    private String scoreFiled;
    private double score = 1.0;
    private String payloadField;

    public IndexDefinition() {
        this(null);
    }

    public IndexDefinition(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isAsync() {
        return this.async;
    }

    public IndexDefinition setAsync(boolean bl) {
        this.async = bl;
        return this;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public IndexDefinition setPrefixes(String ... stringArray) {
        this.prefixes = stringArray;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public IndexDefinition setFilter(String string) {
        this.filter = string;
        return this;
    }

    public String getLanguageField() {
        return this.languageField;
    }

    public IndexDefinition setLanguageField(String string) {
        this.languageField = string;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public IndexDefinition setLanguage(String string) {
        this.language = string;
        return this;
    }

    public String getScoreFiled() {
        return this.scoreFiled;
    }

    public IndexDefinition setScoreFiled(String string) {
        this.scoreFiled = string;
        return this;
    }

    public double getScore() {
        return this.score;
    }

    public IndexDefinition setScore(double d2) {
        this.score = d2;
        return this;
    }

    public String getPayloadField() {
        return this.payloadField;
    }

    @Deprecated
    public IndexDefinition setPayloadField(String string) {
        this.payloadField = string;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.type != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.ON.name());
            commandArguments.add(this.type.name());
        }
        if (this.async) {
            commandArguments.add(SearchProtocol.SearchKeyword.ASYNC.name());
        }
        if (this.prefixes != null && this.prefixes.length > 0) {
            commandArguments.add(SearchProtocol.SearchKeyword.PREFIX.name());
            commandArguments.add(Integer.toString(this.prefixes.length));
            commandArguments.addObjects(this.prefixes);
        }
        if (this.filter != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.FILTER.name());
            commandArguments.add(this.filter);
        }
        if (this.languageField != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LANGUAGE_FIELD.name());
            commandArguments.add(this.languageField);
        }
        if (this.language != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LANGUAGE.name());
            commandArguments.add(this.language);
        }
        if (this.scoreFiled != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SCORE_FIELD.name());
            commandArguments.add(this.scoreFiled);
        }
        if (this.score != 1.0) {
            commandArguments.add(SearchProtocol.SearchKeyword.SCORE.name());
            commandArguments.add(Double.toString(this.score));
        }
        if (this.payloadField != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.PAYLOAD_FIELD.name());
            commandArguments.add(this.payloadField);
        }
    }

    public static enum Type {
        HASH,
        JSON;

    }
}

