/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.List;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class FieldName
implements IParams {
    private static final String AS_ENCODED = "AS";
    private static final byte[] AS_BINARY = SafeEncoder.encode("AS");
    private static final byte[] AS = SafeEncoder.encode("AS");
    private final String name;
    private String attribute;

    public FieldName(String string) {
        this.name = string;
    }

    public FieldName(String string, String string2) {
        this.name = string;
        this.attribute = string2;
    }

    public FieldName as(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Setting null as field attribute is not allowed.");
        }
        if (this.attribute != null) {
            throw new IllegalStateException("Attribute for this field is already set.");
        }
        this.attribute = string;
        return this;
    }

    public int addCommandEncodedArguments(List<String> list) {
        list.add(this.name);
        if (this.attribute == null) {
            return 1;
        }
        list.add(AS_ENCODED);
        list.add(this.attribute);
        return 3;
    }

    public int addCommandBinaryArguments(List<byte[]> list) {
        list.add(SafeEncoder.encode(this.name));
        if (this.attribute == null) {
            return 1;
        }
        list.add(AS_BINARY);
        list.add(SafeEncoder.encode(this.attribute));
        return 3;
    }

    public int addCommandArguments(CommandArguments commandArguments) {
        commandArguments.add(SafeEncoder.encode(this.name));
        if (this.attribute == null) {
            return 1;
        }
        commandArguments.add(AS);
        commandArguments.add(SafeEncoder.encode(this.attribute));
        return 3;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        this.addCommandArguments(commandArguments);
    }

    @Deprecated
    String getName() {
        return this.name;
    }

    public String toString() {
        return this.attribute == null ? this.name : this.name + " AS " + this.attribute;
    }

    public static FieldName of(String string) {
        return new FieldName(string);
    }

    public static FieldName[] convert(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        FieldName[] fieldNameArray = new FieldName[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            fieldNameArray[i2] = FieldName.of(stringArray[i2]);
        }
        return fieldNameArray;
    }
}

