/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.args.SortingOrder;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.search.FieldName;
import me.ulrich.clans.library.redis.jedis.search.LazyRawable;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;

public class FTSearchParams
implements IParams {
    private boolean noContent = false;
    private boolean verbatim = false;
    private boolean noStopwords = false;
    private boolean withScores = false;
    private final List<IParams> filters = new LinkedList<IParams>();
    private Collection<String> inKeys;
    private Collection<String> inFields;
    private Collection<String> returnFields;
    private Collection<FieldName> returnFieldNames;
    private boolean summarize;
    private SummarizeParams summarizeParams;
    private boolean highlight;
    private HighlightParams highlightParams;
    private Integer slop;
    private Long timeout;
    private boolean inOrder;
    private String language;
    private String expander;
    private String scorer;
    private String sortBy;
    private SortingOrder sortOrder;
    private int[] limit;
    private Map<String, Object> params;
    private Integer dialect;

    public static FTSearchParams searchParams() {
        return new FTSearchParams();
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.noContent) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOCONTENT);
        }
        if (this.verbatim) {
            commandArguments.add(SearchProtocol.SearchKeyword.VERBATIM);
        }
        if (this.noStopwords) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOSTOPWORDS);
        }
        if (this.withScores) {
            commandArguments.add(SearchProtocol.SearchKeyword.WITHSCORES);
        }
        if (!this.filters.isEmpty()) {
            this.filters.forEach(iParams -> iParams.addParams(commandArguments));
        }
        if (this.inKeys != null && !this.inKeys.isEmpty()) {
            commandArguments.add(SearchProtocol.SearchKeyword.INKEYS).add(this.inKeys.size()).addObjects(this.inKeys);
        }
        if (this.inFields != null && !this.inFields.isEmpty()) {
            commandArguments.add(SearchProtocol.SearchKeyword.INFIELDS).add(this.inFields.size()).addObjects(this.inFields);
        }
        if (this.returnFieldNames != null && !this.returnFieldNames.isEmpty()) {
            commandArguments.add(SearchProtocol.SearchKeyword.RETURN);
            LazyRawable lazyRawable = new LazyRawable();
            commandArguments.add(lazyRawable);
            int n2 = 0;
            for (FieldName fieldName : this.returnFieldNames) {
                n2 += fieldName.addCommandArguments(commandArguments);
            }
            lazyRawable.setRaw(Protocol.toByteArray(n2));
        } else if (this.returnFields != null && !this.returnFields.isEmpty()) {
            commandArguments.add(SearchProtocol.SearchKeyword.RETURN).add(this.returnFields.size()).addObjects(this.returnFields);
        }
        if (this.summarizeParams != null) {
            commandArguments.addParams(this.summarizeParams);
        } else if (this.summarize) {
            commandArguments.add(SearchProtocol.SearchKeyword.SUMMARIZE);
        }
        if (this.highlightParams != null) {
            commandArguments.addParams(this.highlightParams);
        } else if (this.highlight) {
            commandArguments.add(SearchProtocol.SearchKeyword.HIGHLIGHT);
        }
        if (this.slop != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SLOP).add(this.slop);
        }
        if (this.timeout != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.TIMEOUT).add(this.timeout);
        }
        if (this.inOrder) {
            commandArguments.add(SearchProtocol.SearchKeyword.INORDER);
        }
        if (this.language != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LANGUAGE).add(this.language);
        }
        if (this.expander != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.EXPANDER).add(this.expander);
        }
        if (this.scorer != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SCORER).add(this.scorer);
        }
        if (this.sortBy != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SORTBY).add(this.sortBy);
            if (this.sortOrder != null) {
                commandArguments.add(this.sortOrder);
            }
        }
        if (this.limit != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LIMIT).add(this.limit[0]).add(this.limit[1]);
        }
        if (this.params != null && !this.params.isEmpty()) {
            commandArguments.add(SearchProtocol.SearchKeyword.PARAMS).add(this.params.size() * 2);
            this.params.entrySet().forEach(entry -> commandArguments.add(entry.getKey()).add(entry.getValue()));
        }
        if (this.dialect != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.DIALECT).add(this.dialect);
        }
    }

    public FTSearchParams noContent() {
        this.noContent = true;
        return this;
    }

    public FTSearchParams verbatim() {
        this.verbatim = true;
        return this;
    }

    public FTSearchParams noStopwords() {
        this.noStopwords = true;
        return this;
    }

    public FTSearchParams withScores() {
        this.withScores = true;
        return this;
    }

    public FTSearchParams filter(String string, double d2, double d3) {
        return this.filter(new NumericFilter(string, d2, d3));
    }

    public FTSearchParams filter(String string, double d2, boolean bl, double d3, boolean bl2) {
        return this.filter(new NumericFilter(string, d2, bl, d3, bl2));
    }

    public FTSearchParams filter(NumericFilter numericFilter) {
        this.filters.add(numericFilter);
        return this;
    }

    public FTSearchParams geoFilter(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.geoFilter(new GeoFilter(string, d2, d3, d4, geoUnit));
    }

    public FTSearchParams geoFilter(GeoFilter geoFilter) {
        this.filters.add(geoFilter);
        return this;
    }

    public FTSearchParams inKeys(String ... stringArray) {
        return this.inKeys(Arrays.asList(stringArray));
    }

    public FTSearchParams inKeys(Collection<String> collection) {
        this.inKeys = collection;
        return this;
    }

    public FTSearchParams inFields(String ... stringArray) {
        return this.inFields(Arrays.asList(stringArray));
    }

    public FTSearchParams inFields(Collection<String> collection) {
        if (this.inFields == null) {
            this.inFields = new ArrayList<String>(collection);
        } else {
            this.inFields.addAll(collection);
        }
        return this;
    }

    public FTSearchParams returnFields(String ... stringArray) {
        if (this.returnFieldNames != null) {
            Arrays.stream(stringArray).forEach(string -> this.returnFieldNames.add(FieldName.of(string)));
        } else {
            if (this.returnFields == null) {
                this.returnFields = new ArrayList<String>();
            }
            Arrays.stream(stringArray).forEach(string -> this.returnFields.add((String)string));
        }
        return this;
    }

    public FTSearchParams returnField(FieldName fieldName) {
        this.initReturnFieldNames();
        this.returnFieldNames.add(fieldName);
        return this;
    }

    public FTSearchParams returnFields(FieldName ... fieldNameArray) {
        return this.returnFields(Arrays.asList(fieldNameArray));
    }

    public FTSearchParams returnFields(Collection<FieldName> collection) {
        this.initReturnFieldNames();
        this.returnFieldNames.addAll(collection);
        return this;
    }

    private void initReturnFieldNames() {
        if (this.returnFieldNames == null) {
            this.returnFieldNames = new ArrayList<FieldName>();
        }
        if (this.returnFields != null) {
            this.returnFields.forEach(string -> this.returnFieldNames.add(FieldName.of(string)));
            this.returnFields = null;
        }
    }

    public FTSearchParams summarize() {
        this.summarize = true;
        return this;
    }

    public FTSearchParams summarize(SummarizeParams summarizeParams) {
        this.summarizeParams = summarizeParams;
        return this;
    }

    public FTSearchParams highlight() {
        this.highlight = true;
        return this;
    }

    public FTSearchParams highlight(HighlightParams highlightParams) {
        this.highlightParams = highlightParams;
        return this;
    }

    public FTSearchParams scorer(String string) {
        this.scorer = string;
        return this;
    }

    public FTSearchParams slop(int n2) {
        this.slop = n2;
        return this;
    }

    public FTSearchParams timeout(long l2) {
        this.timeout = l2;
        return this;
    }

    public FTSearchParams inOrder() {
        this.inOrder = true;
        return this;
    }

    public FTSearchParams language(String string) {
        this.language = string;
        return this;
    }

    public FTSearchParams sortBy(String string, SortingOrder sortingOrder) {
        this.sortBy = string;
        this.sortOrder = sortingOrder;
        return this;
    }

    public FTSearchParams limit(int n2, int n3) {
        this.limit = new int[]{n2, n3};
        return this;
    }

    public FTSearchParams addParam(String string, Object object) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(string, object);
        return this;
    }

    public FTSearchParams params(Map<String, Object> map) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>(map);
        } else {
            this.params.putAll(this.params);
        }
        return this;
    }

    public FTSearchParams dialect(int n2) {
        this.dialect = n2;
        return this;
    }

    public boolean getNoContent() {
        return this.noContent;
    }

    public boolean getWithScores() {
        return this.withScores;
    }

    public static SummarizeParams summarizeParams() {
        return new SummarizeParams();
    }

    public static HighlightParams highlightParams() {
        return new HighlightParams();
    }

    public static class HighlightParams
    implements IParams {
        private Collection<String> fields;
        private String[] tags;

        public HighlightParams fields(String string) {
            return this.fields(Arrays.asList(string));
        }

        public HighlightParams fields(Collection<String> collection) {
            this.fields = collection;
            return this;
        }

        public HighlightParams tags(String string, String string2) {
            this.tags = new String[]{string, string2};
            return this;
        }

        @Override
        public void addParams(CommandArguments commandArguments) {
            commandArguments.add(SearchProtocol.SearchKeyword.HIGHLIGHT);
            if (this.fields != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.FIELDS).add(this.fields.size()).addObjects(this.fields);
            }
            if (this.tags != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.TAGS).add(this.tags[0]).add(this.tags[1]);
            }
        }
    }

    public static class SummarizeParams
    implements IParams {
        private Collection<String> fields;
        private Integer fragsNum;
        private Integer fragSize;
        private String separator;

        public SummarizeParams fields(String ... stringArray) {
            return this.fields(Arrays.asList(stringArray));
        }

        public SummarizeParams fields(Collection<String> collection) {
            this.fields = collection;
            return this;
        }

        public SummarizeParams fragsNum(int n2) {
            this.fragsNum = n2;
            return this;
        }

        public SummarizeParams fragSize(int n2) {
            this.fragSize = n2;
            return this;
        }

        public SummarizeParams separator(String string) {
            this.separator = string;
            return this;
        }

        @Override
        public void addParams(CommandArguments commandArguments) {
            commandArguments.add(SearchProtocol.SearchKeyword.SUMMARIZE);
            if (this.fields != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.FIELDS).add(this.fields.size()).addObjects(this.fields);
            }
            if (this.fragsNum != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.FRAGS).add(this.fragsNum);
            }
            if (this.fragSize != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.LEN).add(this.fragSize);
            }
            if (this.separator != null) {
                commandArguments.add(SearchProtocol.SearchKeyword.SEPARATOR).add(this.separator);
            }
        }
    }

    public static class GeoFilter
    implements IParams {
        private final String field;
        private final double lon;
        private final double lat;
        private final double radius;
        private final GeoUnit unit;

        public GeoFilter(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
            this.field = string;
            this.lon = d2;
            this.lat = d3;
            this.radius = d4;
            this.unit = geoUnit;
        }

        @Override
        public void addParams(CommandArguments commandArguments) {
            commandArguments.add(SearchProtocol.SearchKeyword.GEOFILTER).add(this.field).add(this.lon).add(this.lat).add(this.radius).add(this.unit);
        }
    }

    public static class NumericFilter
    implements IParams {
        private final String field;
        private final double min;
        private final boolean exclusiveMin;
        private final double max;
        private final boolean exclusiveMax;

        public NumericFilter(String string, double d2, double d3) {
            this(string, d2, false, d3, false);
        }

        public NumericFilter(String string, double d2, boolean bl, double d3, boolean bl2) {
            this.field = string;
            this.min = d2;
            this.max = d3;
            this.exclusiveMax = bl2;
            this.exclusiveMin = bl;
        }

        @Override
        public void addParams(CommandArguments commandArguments) {
            commandArguments.add(SearchProtocol.SearchKeyword.FILTER).add(this.field).add(this.formatNum(this.min, this.exclusiveMin)).add(this.formatNum(this.max, this.exclusiveMax));
        }

        private Object formatNum(double d2, boolean bl) {
            return bl ? (Object)("(" + d2) : Protocol.toByteArray(d2);
        }
    }
}

