/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.search.IndexDataType;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;

public class FTCreateParams
implements IParams {
    private IndexDataType dataType;
    private Collection<String> prefix;
    private String filter;
    private String language;
    private String languageField;
    private Double score;
    private String scoreField;
    private boolean maxTextFields;
    private boolean noOffsets;
    private Long temporary;
    private boolean noHL;
    private boolean noFields;
    private boolean noFreqs;
    private Collection<String> stopwords;
    private boolean skipInitialScan;

    public static FTCreateParams createParams() {
        return new FTCreateParams();
    }

    public FTCreateParams on(IndexDataType indexDataType) {
        this.dataType = indexDataType;
        return this;
    }

    public FTCreateParams prefix(String ... stringArray) {
        if (this.prefix == null) {
            this.prefix = new ArrayList<String>(stringArray.length);
        }
        Arrays.stream(stringArray).forEach(string -> this.prefix.add((String)string));
        return this;
    }

    public FTCreateParams addPrefix(String string) {
        if (this.prefix == null) {
            this.prefix = new ArrayList<String>();
        }
        this.prefix.add(string);
        return this;
    }

    public FTCreateParams filter(String string) {
        this.filter = string;
        return this;
    }

    public FTCreateParams language(String string) {
        this.language = string;
        return this;
    }

    public FTCreateParams languageField(String string) {
        this.languageField = string;
        return this;
    }

    public FTCreateParams score(double d2) {
        this.score = d2;
        return this;
    }

    public FTCreateParams scoreField(String string) {
        this.scoreField = string;
        return this;
    }

    public FTCreateParams maxTextFields() {
        this.maxTextFields = true;
        return this;
    }

    public FTCreateParams noOffsets() {
        this.noOffsets = true;
        return this;
    }

    public FTCreateParams temporary(long l2) {
        this.temporary = l2;
        return this;
    }

    public FTCreateParams noHL() {
        this.noHL = true;
        return this;
    }

    public FTCreateParams noHighlights() {
        return this.noHL();
    }

    public FTCreateParams noFields() {
        this.noFields = true;
        return this;
    }

    public FTCreateParams noFreqs() {
        this.noFreqs = true;
        return this;
    }

    public FTCreateParams stopwords(String ... stringArray) {
        this.stopwords = Arrays.asList(stringArray);
        return this;
    }

    public FTCreateParams noStopwords() {
        this.stopwords = Collections.emptyList();
        return this;
    }

    public FTCreateParams skipInitialScan() {
        this.skipInitialScan = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.dataType != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.ON).add((Object)this.dataType);
        }
        if (this.prefix != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.PREFIX).add(this.prefix.size()).addObjects(this.prefix);
        }
        if (this.filter != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.FILTER).add(this.filter);
        }
        if (this.language != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LANGUAGE).add(this.language);
        }
        if (this.languageField != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.LANGUAGE_FIELD).add(this.languageField);
        }
        if (this.score != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SCORE).add(this.score);
        }
        if (this.scoreField != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.SCORE_FIELD).add(this.scoreField);
        }
        if (this.maxTextFields) {
            commandArguments.add(SearchProtocol.SearchKeyword.MAXTEXTFIELDS);
        }
        if (this.noOffsets) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOOFFSETS);
        }
        if (this.temporary != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.TEMPORARY).add(this.temporary);
        }
        if (this.noHL) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOHL);
        }
        if (this.noFields) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOFIELDS);
        }
        if (this.noFreqs) {
            commandArguments.add(SearchProtocol.SearchKeyword.NOFREQS);
        }
        if (this.stopwords != null) {
            commandArguments.add(SearchProtocol.SearchKeyword.STOPWORDS).add(this.stopwords.size());
            this.stopwords.forEach(string -> commandArguments.add(string));
        }
        if (this.skipInitialScan) {
            commandArguments.add(SearchProtocol.SearchKeyword.SKIPINITIALSCAN);
        }
    }
}

