/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class Document
implements Serializable {
    private static final long serialVersionUID = 4884173545291367373L;
    private final String id;
    private double score;
    private byte[] payload;
    private final Map<String, Object> properties;

    public Document(String string, double d2) {
        this(string, new HashMap<String, Object>(), d2);
    }

    public Document(String string) {
        this(string, 1.0);
    }

    public Document(String string, Map<String, Object> map) {
        this(string, map, 1.0);
    }

    public Document(String string, Map<String, Object> map, double d2) {
        this(string, map, d2, null);
    }

    public Document(String string, Map<String, Object> map, double d2, byte[] byArray) {
        this.id = string;
        this.properties = new HashMap<String, Object>(map);
        this.score = d2;
        this.payload = byArray;
    }

    public Iterable<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet();
    }

    public static Document load(String string, double d2, byte[] byArray, List<byte[]> list) {
        return Document.load(string, d2, byArray, list, true);
    }

    public static Document load(String string, double d2, byte[] byArray, List<byte[]> list, boolean bl) {
        Document document = new Document(string, d2);
        document.payload = byArray;
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                byte[] byArray2 = list.get(i2);
                byte[] byArray3 = list.get(i2 + 1);
                String string2 = SafeEncoder.encode(byArray2);
                byte[] byArray4 = byArray3 == null ? null : (bl ? (Object)SafeEncoder.encode(byArray3) : byArray3);
                document.set(string2, byArray4);
            }
        }
        return document;
    }

    public Document set(String string, Object object) {
        this.properties.put(string, object);
        return this;
    }

    public Object get(String string) {
        return this.properties.get(string);
    }

    public String getString(String string) {
        Object object = this.properties.get(string);
        if (object instanceof String) {
            return (String)object;
        }
        return object instanceof byte[] ? SafeEncoder.encode((byte[])object) : object.toString();
    }

    public double getScore() {
        return this.score;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Document setScore(float f2) {
        this.score = f2;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    public String toString() {
        return "id:" + this.getId() + ", score: " + this.getScore() + ", payload:" + (this.getPayload() == null ? "null" : SafeEncoder.encode(this.getPayload())) + ", properties:" + this.getProperties();
    }
}

