/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.resps;

import java.util.Arrays;
import java.util.Objects;
import me.ulrich.clans.library.redis.jedis.util.ByteArrayComparator;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class Tuple
implements Comparable<Tuple> {
    private byte[] element;
    private Double score;

    public Tuple(String string, Double d2) {
        this(SafeEncoder.encode(string), d2);
    }

    public Tuple(byte[] byArray, Double d2) {
        this.element = byArray;
        this.score = d2;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3;
        if (null != this.element) {
            for (byte by : this.element) {
                n3 = 31 * n3 + by;
            }
        }
        long l2 = Double.doubleToLongBits(this.score);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Tuple)) {
            return false;
        }
        Tuple tuple = (Tuple)object;
        if (!Arrays.equals(this.element, tuple.element)) {
            return false;
        }
        return Objects.equals(this.score, tuple.score);
    }

    @Override
    public int compareTo(Tuple tuple) {
        return Tuple.compare(this, tuple);
    }

    public static int compare(Tuple tuple, Tuple tuple2) {
        int n2 = Double.compare(tuple.score, tuple2.score);
        if (n2 != 0) {
            return n2;
        }
        return ByteArrayComparator.compare(tuple.element, tuple2.element);
    }

    public String getElement() {
        if (null != this.element) {
            return SafeEncoder.encode(this.element);
        }
        return null;
    }

    public byte[] getBinaryElement() {
        return this.element;
    }

    public double getScore() {
        return this.score;
    }

    public String toString() {
        return '[' + SafeEncoder.encode(this.element) + ',' + this.score + ']';
    }
}

