/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.resps;

import java.util.Arrays;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class GeoRadiusResponse {
    private byte[] member;
    private double distance;
    private GeoCoordinate coordinate;
    private long rawScore;

    public GeoRadiusResponse(byte[] byArray) {
        this.member = byArray;
    }

    public void setDistance(double d2) {
        this.distance = d2;
    }

    public void setCoordinate(GeoCoordinate geoCoordinate) {
        this.coordinate = geoCoordinate;
    }

    public byte[] getMember() {
        return this.member;
    }

    public String getMemberByString() {
        return SafeEncoder.encode(this.member);
    }

    public double getDistance() {
        return this.distance;
    }

    public GeoCoordinate getCoordinate() {
        return this.coordinate;
    }

    public long getRawScore() {
        return this.rawScore;
    }

    public void setRawScore(long l2) {
        this.rawScore = l2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GeoRadiusResponse)) {
            return false;
        }
        GeoRadiusResponse geoRadiusResponse = (GeoRadiusResponse)object;
        return Double.compare(this.distance, geoRadiusResponse.getDistance()) == 0 && this.rawScore == geoRadiusResponse.getRawScore() && this.coordinate.equals(geoRadiusResponse.coordinate) && Arrays.equals(this.member, geoRadiusResponse.getMember());
    }
}

