/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.ConnectionPool;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.ShardedCommandArguments;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;
import me.ulrich.clans.library.redis.jedis.util.Hashing;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ShardedConnectionProvider
implements ConnectionProvider {
    private final TreeMap<Long, HostAndPort> nodes = new TreeMap();
    private final Map<String, ConnectionPool> resources = new HashMap<String, ConnectionPool>();
    private final JedisClientConfig clientConfig;
    private final GenericObjectPoolConfig<Connection> poolConfig;
    private final Hashing algo;

    public ShardedConnectionProvider(List<HostAndPort> list) {
        this(list, DefaultJedisClientConfig.builder().build());
    }

    public ShardedConnectionProvider(List<HostAndPort> list, JedisClientConfig jedisClientConfig) {
        this(list, jedisClientConfig, new GenericObjectPoolConfig<Connection>());
    }

    public ShardedConnectionProvider(List<HostAndPort> list, JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(list, jedisClientConfig, genericObjectPoolConfig, Hashing.MURMUR_HASH);
    }

    public ShardedConnectionProvider(List<HostAndPort> list, JedisClientConfig jedisClientConfig, Hashing hashing) {
        this(list, jedisClientConfig, new GenericObjectPoolConfig<Connection>(), hashing);
    }

    public ShardedConnectionProvider(List<HostAndPort> list, JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, Hashing hashing) {
        this.clientConfig = jedisClientConfig;
        this.poolConfig = genericObjectPoolConfig;
        this.algo = hashing;
        this.initialize(list);
    }

    private void initialize(List<HostAndPort> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HostAndPort hostAndPort = list.get(i2);
            for (int i3 = 0; i3 < 160; ++i3) {
                Long l2 = this.algo.hash("SHARD-" + i2 + "-NODE-" + i3);
                this.nodes.put(l2, hostAndPort);
                this.setupNodeIfNotExist(hostAndPort);
            }
        }
    }

    private ConnectionPool setupNodeIfNotExist(HostAndPort hostAndPort) {
        String string = hostAndPort.toString();
        ConnectionPool connectionPool = this.resources.get(string);
        if (connectionPool != null) {
            return connectionPool;
        }
        ConnectionPool connectionPool2 = new ConnectionPool(hostAndPort, this.clientConfig, this.poolConfig);
        this.resources.put(string, connectionPool2);
        return connectionPool2;
    }

    public Hashing getHashingAlgo() {
        return this.algo;
    }

    private void reset() {
        for (ConnectionPool connectionPool : this.resources.values()) {
            try {
                if (connectionPool == null) continue;
                connectionPool.destroy();
            }
            catch (RuntimeException runtimeException) {}
        }
        this.resources.clear();
        this.nodes.clear();
    }

    @Override
    public void close() {
        this.reset();
    }

    public HostAndPort getNode(Long l2) {
        return l2 != null ? this.getNodeFromHash(l2) : null;
    }

    public Connection getConnection(HostAndPort hostAndPort) {
        return hostAndPort != null ? this.setupNodeIfNotExist(hostAndPort).getResource() : this.getConnection();
    }

    @Override
    public Connection getConnection(CommandArguments commandArguments) {
        Long l2 = ((ShardedCommandArguments)commandArguments).getKeyHash();
        return l2 != null ? this.getConnection(this.getNodeFromHash(l2)) : this.getConnection();
    }

    private List<ConnectionPool> getShuffledNodesPool() {
        ArrayList<ConnectionPool> arrayList = new ArrayList<ConnectionPool>(this.resources.values());
        Collections.shuffle(arrayList);
        return arrayList;
    }

    @Override
    public Connection getConnection() {
        List<ConnectionPool> list = this.getShuffledNodesPool();
        JedisException jedisException = null;
        for (ConnectionPool connectionPool : list) {
            Connection connection = null;
            try {
                connection = connectionPool.getResource();
                if (connection == null) continue;
                connection.ping();
                return connection;
            }
            catch (JedisException jedisException2) {
                if (jedisException == null) {
                    jedisException = jedisException2;
                }
                if (connection == null) continue;
                connection.close();
            }
        }
        JedisException jedisException3 = new JedisException("No reachable shard.");
        if (jedisException != null) {
            jedisException3.addSuppressed(jedisException);
        }
        throw jedisException3;
    }

    private HostAndPort getNodeFromHash(Long l2) {
        SortedMap<Long, HostAndPort> sortedMap = this.nodes.tailMap(l2);
        if (sortedMap.isEmpty()) {
            return this.nodes.get(this.nodes.firstKey());
        }
        return (HostAndPort)sortedMap.get(sortedMap.firstKey());
    }
}

