/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.providers;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.ConnectionFactory;
import me.ulrich.clans.library.redis.jedis.ConnectionPool;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;
import me.ulrich.clans.library.redis.jedis.util.Pool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class PooledConnectionProvider
implements ConnectionProvider {
    private final Pool<Connection> pool;

    public PooledConnectionProvider(HostAndPort hostAndPort) {
        this(new ConnectionFactory(hostAndPort));
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this(new ConnectionFactory(hostAndPort, jedisClientConfig));
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> pooledObjectFactory) {
        this(pooledObjectFactory, new GenericObjectPoolConfig<Connection>());
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> pooledObjectFactory, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(new ConnectionPool(pooledObjectFactory, genericObjectPoolConfig));
    }

    private PooledConnectionProvider(Pool<Connection> pool) {
        this.pool = pool;
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public final Pool<Connection> getPool() {
        return this.pool;
    }

    @Override
    public Connection getConnection() {
        return this.pool.getResource();
    }

    @Override
    public Connection getConnection(CommandArguments commandArguments) {
        return this.pool.getResource();
    }
}

