/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.ClusterCommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.ConnectionPool;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisClusterInfoCache;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisClusterOperationException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ClusterConnectionProvider
implements ConnectionProvider {
    protected final JedisClusterInfoCache cache;

    public ClusterConnectionProvider(Set<HostAndPort> set, JedisClientConfig jedisClientConfig) {
        this.cache = new JedisClusterInfoCache(jedisClientConfig, set);
        this.initializeSlotsCache(set, jedisClientConfig);
    }

    public ClusterConnectionProvider(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this.cache = new JedisClusterInfoCache(jedisClientConfig, genericObjectPoolConfig, set);
        this.initializeSlotsCache(set, jedisClientConfig);
    }

    private void initializeSlotsCache(Set<HostAndPort> set, JedisClientConfig jedisClientConfig) {
        ArrayList<HostAndPort> arrayList = new ArrayList<HostAndPort>(set);
        Collections.shuffle(arrayList);
        for (HostAndPort hostAndPort : arrayList) {
            try (Connection connection = new Connection(hostAndPort, jedisClientConfig);){
                this.cache.discoverClusterNodesAndSlots(connection);
                return;
            }
            catch (JedisConnectionException jedisConnectionException) {
            }
        }
        throw new JedisClusterOperationException("Could not initialize cluster slots cache.");
    }

    @Override
    public void close() {
        this.cache.reset();
    }

    public void renewSlotCache() {
        this.cache.renewClusterSlots(null);
    }

    public void renewSlotCache(Connection connection) {
        this.cache.renewClusterSlots(connection);
    }

    public Map<String, ConnectionPool> getNodes() {
        return this.cache.getNodes();
    }

    public HostAndPort getNode(int n2) {
        return n2 >= 0 ? this.cache.getSlotNode(n2) : null;
    }

    public Connection getConnection(HostAndPort hostAndPort) {
        return hostAndPort != null ? this.cache.setupNodeIfNotExist(hostAndPort).getResource() : this.getConnection();
    }

    @Override
    public Connection getConnection(CommandArguments commandArguments) {
        int n2 = ((ClusterCommandArguments)commandArguments).getCommandHashSlot();
        return n2 >= 0 ? this.getConnectionFromSlot(n2) : this.getConnection();
    }

    @Override
    public Connection getConnection() {
        List<ConnectionPool> list = this.cache.getShuffledNodesPool();
        JedisException jedisException = null;
        for (ConnectionPool connectionPool : list) {
            Connection connection = null;
            try {
                connection = connectionPool.getResource();
                if (connection == null) continue;
                connection.ping();
                return connection;
            }
            catch (JedisException jedisException2) {
                if (jedisException == null) {
                    jedisException = jedisException2;
                }
                if (connection == null) continue;
                connection.close();
            }
        }
        JedisClusterOperationException jedisClusterOperationException = new JedisClusterOperationException("No reachable node in cluster.");
        if (jedisException != null) {
            jedisClusterOperationException.addSuppressed(jedisException);
        }
        throw jedisClusterOperationException;
    }

    public Connection getConnectionFromSlot(int n2) {
        ConnectionPool connectionPool = this.cache.getSlotPool(n2);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        this.renewSlotCache();
        connectionPool = this.cache.getSlotPool(n2);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }
}

