/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.args.RawableFactory;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class ZRangeParams
implements IParams {
    private final Protocol.Keyword by;
    private final Rawable min;
    private final Rawable max;
    private boolean rev = false;
    private boolean limit = false;
    private int offset;
    private int count;

    private ZRangeParams() {
        throw new InstantiationError("Empty constructor must not be called.");
    }

    public ZRangeParams(int n2, int n3) {
        this.by = null;
        this.min = RawableFactory.from(n2);
        this.max = RawableFactory.from(n3);
    }

    public static ZRangeParams zrangeParams(int n2, int n3) {
        return new ZRangeParams(n2, n3);
    }

    public ZRangeParams(double d2, double d3) {
        this.by = Protocol.Keyword.BYSCORE;
        this.min = RawableFactory.from(d2);
        this.max = RawableFactory.from(d3);
    }

    public static ZRangeParams zrangeByScoreParams(double d2, double d3) {
        return new ZRangeParams(d2, d3);
    }

    private ZRangeParams(Protocol.Keyword keyword, Rawable rawable, Rawable rawable2) {
        if (keyword != null && keyword != Protocol.Keyword.BYSCORE && keyword != Protocol.Keyword.BYLEX) {
            throw new IllegalArgumentException(keyword.name() + " is not a valid ZRANGE type argument.");
        }
        this.by = keyword;
        this.min = rawable;
        this.max = rawable2;
    }

    public ZRangeParams(Protocol.Keyword keyword, String string, String string2) {
        this(keyword, RawableFactory.from(string), RawableFactory.from(string2));
    }

    public ZRangeParams(Protocol.Keyword keyword, byte[] byArray, byte[] byArray2) {
        this(keyword, RawableFactory.from(byArray), RawableFactory.from(byArray2));
    }

    public static ZRangeParams zrangeByLexParams(String string, String string2) {
        return new ZRangeParams(Protocol.Keyword.BYLEX, string, string2);
    }

    public static ZRangeParams zrangeByLexParams(byte[] byArray, byte[] byArray2) {
        return new ZRangeParams(Protocol.Keyword.BYLEX, byArray, byArray2);
    }

    public ZRangeParams rev() {
        this.rev = true;
        return this;
    }

    public ZRangeParams limit(int n2, int n3) {
        this.limit = true;
        this.offset = n2;
        this.count = n3;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        commandArguments.add(this.min).add(this.max);
        if (this.by != null) {
            commandArguments.add(this.by);
        }
        if (this.rev) {
            commandArguments.add(Protocol.Keyword.REV);
        }
        if (this.limit) {
            commandArguments.add(Protocol.Keyword.LIMIT).add(this.offset).add(this.count);
        }
    }
}

