/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class XTrimParams
implements IParams {
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private String minId;
    private Long limit;

    public static XTrimParams xTrimParams() {
        return new XTrimParams();
    }

    public XTrimParams maxLen(long l2) {
        this.maxLen = l2;
        return this;
    }

    public XTrimParams minId(String string) {
        this.minId = string;
        return this;
    }

    public XTrimParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XTrimParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XTrimParams limit(long l2) {
        this.limit = l2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.maxLen != null) {
            commandArguments.add(Protocol.Keyword.MAXLEN.getRaw());
            if (this.approximateTrimming) {
                commandArguments.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                commandArguments.add(Protocol.BYTES_EQUAL);
            }
            commandArguments.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            commandArguments.add(Protocol.Keyword.MINID.getRaw());
            if (this.approximateTrimming) {
                commandArguments.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                commandArguments.add(Protocol.BYTES_EQUAL);
            }
            commandArguments.add(SafeEncoder.encode(this.minId));
        }
        if (this.limit != null) {
            commandArguments.add(Protocol.Keyword.LIMIT.getRaw());
            commandArguments.add(Protocol.toByteArray(this.limit));
        }
    }
}

