/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.args.RawableFactory;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class XPendingParams
implements IParams {
    private boolean legacy = true;
    private Long idle;
    private Rawable start;
    private Rawable end;
    private int count = Integer.MIN_VALUE;
    private Rawable consumer;

    @Deprecated
    public XPendingParams() {
    }

    @Deprecated
    public static XPendingParams xPendingParams() {
        return new XPendingParams();
    }

    public XPendingParams(StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        this(streamEntryID.toString(), streamEntryID2.toString(), n2);
    }

    public XPendingParams(String string, String string2, int n2) {
        this(RawableFactory.from(string), RawableFactory.from(string2), n2);
    }

    public XPendingParams(byte[] byArray, byte[] byArray2, int n2) {
        this(RawableFactory.from(byArray), RawableFactory.from(byArray2), n2);
    }

    private XPendingParams(Rawable rawable, Rawable rawable2, int n2) {
        this.legacy = false;
        this.start = rawable;
        this.end = rawable2;
        this.count = n2;
    }

    public static XPendingParams xPendingParams(StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return new XPendingParams(streamEntryID, streamEntryID2, n2);
    }

    public static XPendingParams xPendingParams(String string, String string2, int n2) {
        return new XPendingParams(string, string2, n2);
    }

    public static XPendingParams xPendingParams(byte[] byArray, byte[] byArray2, int n2) {
        return new XPendingParams(byArray, byArray2, n2);
    }

    public XPendingParams idle(long l2) {
        this.idle = l2;
        return this;
    }

    @Deprecated
    public XPendingParams start(StreamEntryID streamEntryID) {
        this.start = RawableFactory.from(streamEntryID.toString());
        return this;
    }

    @Deprecated
    public XPendingParams end(StreamEntryID streamEntryID) {
        this.end = RawableFactory.from(streamEntryID.toString());
        return this;
    }

    public XPendingParams count(int n2) {
        this.count = n2;
        return this;
    }

    public XPendingParams consumer(String string) {
        this.consumer = RawableFactory.from(string);
        return this;
    }

    public XPendingParams consumer(byte[] byArray) {
        this.consumer = RawableFactory.from(byArray);
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.idle != null) {
            commandArguments.add(Protocol.Keyword.IDLE).add(Protocol.toByteArray(this.idle));
        }
        if (this.legacy) {
            if (this.start == null) {
                commandArguments.add("-");
            } else {
                commandArguments.add(this.start);
            }
            if (this.end == null) {
                commandArguments.add("+");
            } else {
                commandArguments.add(this.end);
            }
            if (this.count != Integer.MIN_VALUE) {
                commandArguments.add(Protocol.toByteArray(this.count));
            }
        } else {
            commandArguments.add(this.start).add(this.end).add(Protocol.toByteArray(this.count));
        }
        if (this.consumer != null) {
            commandArguments.add(this.consumer);
        }
    }
}

