/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import java.util.Arrays;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class XAddParams
implements IParams {
    private static final byte[] NEW_ENTRY = SafeEncoder.encode(StreamEntryID.NEW_ENTRY.toString());
    private byte[] id;
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minId;
    private Long limit;

    public static XAddParams xAddParams() {
        return new XAddParams();
    }

    public XAddParams noMkStream() {
        this.nomkstream = true;
        return this;
    }

    public XAddParams id(byte[] byArray) {
        this.id = Arrays.copyOf(byArray, byArray.length);
        return this;
    }

    public XAddParams id(String string) {
        this.id = SafeEncoder.encode(string);
        return this;
    }

    public XAddParams id(StreamEntryID streamEntryID) {
        return this.id(streamEntryID.toString());
    }

    public XAddParams id(long l2, long l3) {
        return this.id(l2 + "-" + l3);
    }

    public XAddParams id(long l2) {
        return this.id(l2 + "-*");
    }

    public XAddParams maxLen(long l2) {
        this.maxLen = l2;
        return this;
    }

    public XAddParams minId(String string) {
        this.minId = string;
        return this;
    }

    public XAddParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XAddParams limit(long l2) {
        this.limit = l2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.nomkstream) {
            commandArguments.add(Protocol.Keyword.NOMKSTREAM.getRaw());
        }
        if (this.maxLen != null) {
            commandArguments.add(Protocol.Keyword.MAXLEN.getRaw());
            if (this.approximateTrimming) {
                commandArguments.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                commandArguments.add(Protocol.BYTES_EQUAL);
            }
            commandArguments.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            commandArguments.add(Protocol.Keyword.MINID.getRaw());
            if (this.approximateTrimming) {
                commandArguments.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                commandArguments.add(Protocol.BYTES_EQUAL);
            }
            commandArguments.add(SafeEncoder.encode(this.minId));
        }
        if (this.limit != null) {
            commandArguments.add(Protocol.Keyword.LIMIT.getRaw());
            commandArguments.add(Protocol.toByteArray(this.limit));
        }
        commandArguments.add(this.id != null ? this.id : NEW_ENTRY);
    }
}

