/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.SortingOrder;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class SortingParams
implements IParams {
    private final List<byte[]> params = new ArrayList<byte[]>();

    public SortingParams by(String string) {
        return this.by(SafeEncoder.encode(string));
    }

    public SortingParams by(byte[] byArray) {
        this.params.add(Protocol.Keyword.BY.getRaw());
        this.params.add(byArray);
        return this;
    }

    public SortingParams nosort() {
        this.params.add(Protocol.Keyword.BY.getRaw());
        this.params.add(Protocol.Keyword.NOSORT.getRaw());
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public SortingParams desc() {
        return this.sortingOrder(SortingOrder.DESC);
    }

    public SortingParams asc() {
        return this.sortingOrder(SortingOrder.ASC);
    }

    public SortingParams sortingOrder(SortingOrder sortingOrder) {
        this.params.add(sortingOrder.getRaw());
        return this;
    }

    public SortingParams limit(int n2, int n3) {
        this.params.add(Protocol.Keyword.LIMIT.getRaw());
        this.params.add(Protocol.toByteArray(n2));
        this.params.add(Protocol.toByteArray(n3));
        return this;
    }

    public SortingParams alpha() {
        this.params.add(Protocol.Keyword.ALPHA.getRaw());
        return this;
    }

    public SortingParams get(String ... stringArray) {
        for (String string : stringArray) {
            this.params.add(Protocol.Keyword.GET.getRaw());
            this.params.add(SafeEncoder.encode(string));
        }
        return this;
    }

    public SortingParams get(byte[] ... byArray) {
        for (byte[] byArray2 : byArray) {
            this.params.add(Protocol.Keyword.GET.getRaw());
            this.params.add(byArray2);
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        for (byte[] byArray : this.params) {
            commandArguments.add(byArray);
        }
    }
}

