/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.SaveMode;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class ShutdownParams
implements IParams {
    private SaveMode saveMode;
    private boolean now;
    private boolean force;

    public static ShutdownParams shutdownParams() {
        return new ShutdownParams();
    }

    public ShutdownParams saveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
        return this;
    }

    public ShutdownParams nosave() {
        return this.saveMode(SaveMode.NOSAVE);
    }

    public ShutdownParams save() {
        return this.saveMode(SaveMode.SAVE);
    }

    public ShutdownParams now() {
        this.now = true;
        return this;
    }

    public ShutdownParams force() {
        this.force = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.saveMode != null) {
            commandArguments.add(SafeEncoder.encode(this.saveMode.getRaw()));
        }
        if (this.now) {
            commandArguments.add(Protocol.Keyword.NOW.getRaw());
        }
        if (this.force) {
            commandArguments.add(Protocol.Keyword.FORCE.getRaw());
        }
    }
}

