/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.params.Params;

public class SetParams
extends Params
implements IParams {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";
    private static final String EXAT = "exat";
    private static final String PXAT = "pxat";
    private static final String KEEPTTL = "keepttl";
    private static final String GET = "get";

    public static SetParams setParams() {
        return new SetParams();
    }

    public SetParams ex(long l2) {
        this.addParam(EX, l2);
        return this;
    }

    public SetParams px(long l2) {
        this.addParam(PX, l2);
        return this;
    }

    public SetParams nx() {
        this.addParam(NX);
        return this;
    }

    public SetParams xx() {
        this.addParam(XX);
        return this;
    }

    public SetParams exAt(long l2) {
        this.addParam(EXAT, l2);
        return this;
    }

    public SetParams pxAt(long l2) {
        this.addParam(PXAT, l2);
        return this;
    }

    public SetParams keepttl() {
        this.addParam(KEEPTTL);
        return this;
    }

    @Deprecated
    public SetParams get() {
        this.addParam(GET);
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.contains(NX)) {
            commandArguments.add(Protocol.Keyword.NX);
        }
        if (this.contains(XX)) {
            commandArguments.add(Protocol.Keyword.XX);
        }
        if (this.contains(EX)) {
            commandArguments.add(Protocol.Keyword.EX);
            commandArguments.add(Protocol.toByteArray((Long)this.getParam(EX)));
        }
        if (this.contains(PX)) {
            commandArguments.add(Protocol.Keyword.PX);
            commandArguments.add(Protocol.toByteArray((Long)this.getParam(PX)));
        }
        if (this.contains(EXAT)) {
            commandArguments.add(Protocol.Keyword.EXAT);
            commandArguments.add(Protocol.toByteArray((Long)this.getParam(EXAT)));
        }
        if (this.contains(PXAT)) {
            commandArguments.add(Protocol.Keyword.PXAT);
            commandArguments.add(Protocol.toByteArray((Long)this.getParam(PXAT)));
        }
        if (this.contains(KEEPTTL)) {
            commandArguments.add(Protocol.Keyword.KEEPTTL);
        }
        if (this.contains(GET)) {
            commandArguments.add(Protocol.Keyword.GET);
        }
    }
}

