/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class ScanParams
implements IParams {
    private final Map<Protocol.Keyword, ByteBuffer> params = new EnumMap<Protocol.Keyword, ByteBuffer>(Protocol.Keyword.class);
    public static final String SCAN_POINTER_START = String.valueOf(0);
    public static final byte[] SCAN_POINTER_START_BINARY = SafeEncoder.encode(SCAN_POINTER_START);

    public ScanParams match(byte[] byArray) {
        this.params.put(Protocol.Keyword.MATCH, ByteBuffer.wrap(byArray));
        return this;
    }

    public ScanParams match(String string) {
        this.params.put(Protocol.Keyword.MATCH, ByteBuffer.wrap(SafeEncoder.encode(string)));
        return this;
    }

    public ScanParams count(Integer n2) {
        this.params.put(Protocol.Keyword.COUNT, ByteBuffer.wrap(Protocol.toByteArray(n2)));
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        for (Map.Entry<Protocol.Keyword, ByteBuffer> entry : this.params.entrySet()) {
            commandArguments.add(entry.getKey());
            commandArguments.add(entry.getValue().array());
        }
    }

    public byte[] binaryMatch() {
        if (this.params.containsKey(Protocol.Keyword.MATCH)) {
            return this.params.get(Protocol.Keyword.MATCH).array();
        }
        return null;
    }

    public String match() {
        if (this.params.containsKey(Protocol.Keyword.MATCH)) {
            return new String(this.params.get(Protocol.Keyword.MATCH).array());
        }
        return null;
    }
}

