/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class RestoreParams
implements IParams {
    private boolean replace;
    private boolean absTtl;
    private Long idleTime;
    private Long frequency;

    public static RestoreParams restoreParams() {
        return new RestoreParams();
    }

    public RestoreParams replace() {
        this.replace = true;
        return this;
    }

    public RestoreParams absTtl() {
        this.absTtl = true;
        return this;
    }

    public RestoreParams idleTime(long l2) {
        this.idleTime = l2;
        return this;
    }

    public RestoreParams frequency(long l2) {
        this.frequency = l2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.replace) {
            commandArguments.add(Protocol.Keyword.REPLACE.getRaw());
        }
        if (this.absTtl) {
            commandArguments.add(Protocol.Keyword.ABSTTL.getRaw());
        }
        if (this.idleTime != null) {
            commandArguments.add(Protocol.Keyword.IDLETIME.getRaw());
            commandArguments.add(Protocol.toByteArray(this.idleTime));
        }
        if (this.frequency != null) {
            commandArguments.add(Protocol.Keyword.FREQ.getRaw());
            commandArguments.add(Protocol.toByteArray(this.frequency));
        }
    }
}

