/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public abstract class Params {
    private Map<String, Object> params;

    public <T> T getParam(String string) {
        if (this.params == null) {
            return null;
        }
        return (T)this.params.get(string);
    }

    public byte[][] getByteParams() {
        if (this.params == null) {
            return new byte[0][];
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            arrayList.add(SafeEncoder.encode(entry.getKey()));
            Object object = entry.getValue();
            if (object == null) continue;
            if (object instanceof byte[]) {
                arrayList.add((byte[])object);
                continue;
            }
            if (object instanceof Rawable) {
                arrayList.add(((Rawable)object).getRaw());
                continue;
            }
            if (object instanceof Boolean) {
                arrayList.add(Protocol.toByteArray((Boolean)object));
                continue;
            }
            if (object instanceof Integer) {
                arrayList.add(Protocol.toByteArray((Integer)object));
                continue;
            }
            if (object instanceof Long) {
                arrayList.add(Protocol.toByteArray((Long)object));
                continue;
            }
            if (object instanceof Double) {
                arrayList.add(Protocol.toByteArray((Double)object));
                continue;
            }
            arrayList.add(SafeEncoder.encode(String.valueOf(object)));
        }
        return (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
    }

    protected boolean contains(String string) {
        if (this.params == null) {
            return false;
        }
        return this.params.containsKey(string);
    }

    protected void addParam(String string, Object object) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(string, object);
    }

    protected void addParam(String string) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(string, null);
    }

    public String toString() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.params != null) {
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                arrayList.add(entry.getKey());
                Object object = entry.getValue();
                if (object == null) continue;
                arrayList.add(SafeEncoder.encodeObject(object));
            }
        }
        return arrayList.toString();
    }
}

