/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class LCSParams
implements IParams {
    private boolean len = false;
    private boolean idx = false;
    private Long minMatchLen;
    private boolean withMatchLen = false;

    public static LCSParams LCSParams() {
        return new LCSParams();
    }

    public LCSParams len() {
        this.len = true;
        return this;
    }

    public LCSParams idx() {
        this.idx = true;
        return this;
    }

    public LCSParams minMatchLen(long l2) {
        this.minMatchLen = l2;
        return this;
    }

    public LCSParams withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.len) {
            commandArguments.add(Protocol.Keyword.LEN);
        }
        if (this.idx) {
            commandArguments.add(Protocol.Keyword.IDX);
        }
        if (this.minMatchLen != null) {
            commandArguments.add(Protocol.Keyword.MINMATCHLEN).add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            commandArguments.add(Protocol.Keyword.WITHMATCHLEN);
        }
    }
}

