/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.args.SortingOrder;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class GeoSearchParam
implements IParams {
    private boolean fromMember = false;
    private boolean fromLonLat = false;
    private String member;
    private GeoCoordinate coord;
    private boolean byRadius = false;
    private boolean byBox = false;
    private double radius;
    private double width;
    private double height;
    private GeoUnit unit;
    private boolean withCoord = false;
    private boolean withDist = false;
    private boolean withHash = false;
    private Integer count = null;
    private boolean any = false;
    private SortingOrder sortingOrder = null;

    public static GeoSearchParam geoSearchParam() {
        return new GeoSearchParam();
    }

    public GeoSearchParam fromMember(String string) {
        this.fromMember = true;
        this.member = string;
        return this;
    }

    public GeoSearchParam fromLonLat(double d2, double d3) {
        this.fromLonLat = true;
        this.coord = new GeoCoordinate(d2, d3);
        return this;
    }

    public GeoSearchParam fromLonLat(GeoCoordinate geoCoordinate) {
        this.fromLonLat = true;
        this.coord = geoCoordinate;
        return this;
    }

    public GeoSearchParam byRadius(double d2, GeoUnit geoUnit) {
        this.byRadius = true;
        this.radius = d2;
        this.unit = geoUnit;
        return this;
    }

    public GeoSearchParam byBox(double d2, double d3, GeoUnit geoUnit) {
        this.byBox = true;
        this.width = d2;
        this.height = d3;
        this.unit = geoUnit;
        return this;
    }

    public GeoSearchParam withCoord() {
        this.withCoord = true;
        return this;
    }

    public GeoSearchParam withDist() {
        this.withDist = true;
        return this;
    }

    public GeoSearchParam withHash() {
        this.withHash = true;
        return this;
    }

    public GeoSearchParam asc() {
        return this.sortingOrder(SortingOrder.ASC);
    }

    public GeoSearchParam desc() {
        return this.sortingOrder(SortingOrder.DESC);
    }

    public GeoSearchParam sortingOrder(SortingOrder sortingOrder) {
        this.sortingOrder = sortingOrder;
        return this;
    }

    public GeoSearchParam count(int n2) {
        return this.count(n2, false);
    }

    public GeoSearchParam count(int n2, boolean bl) {
        if (n2 > 0) {
            this.count = n2;
            if (bl) {
                this.any = true;
            }
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.fromMember) {
            commandArguments.add(Protocol.Keyword.FROMMEMBER);
            commandArguments.add(this.member);
        } else if (this.fromLonLat) {
            commandArguments.add(Protocol.Keyword.FROMLONLAT);
            commandArguments.add(this.coord.getLongitude());
            commandArguments.add(this.coord.getLatitude());
        }
        if (this.byRadius) {
            commandArguments.add(Protocol.Keyword.BYRADIUS);
            commandArguments.add(this.radius);
        } else if (this.byBox) {
            commandArguments.add(Protocol.Keyword.BYBOX);
            commandArguments.add(this.width);
            commandArguments.add(this.height);
        }
        commandArguments.add(this.unit);
        if (this.withCoord) {
            commandArguments.add(Protocol.Keyword.WITHCOORD);
        }
        if (this.withDist) {
            commandArguments.add(Protocol.Keyword.WITHDIST);
        }
        if (this.withHash) {
            commandArguments.add(Protocol.Keyword.WITHHASH);
        }
        if (this.count != null) {
            commandArguments.add(Protocol.Keyword.COUNT).add(this.count);
            if (this.any) {
                commandArguments.add(Protocol.Keyword.ANY);
            }
        }
        if (this.sortingOrder != null) {
            commandArguments.add(this.sortingOrder);
        }
    }
}

