/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.SortingOrder;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class GeoRadiusParam
implements IParams {
    private boolean withCoord = false;
    private boolean withDist = false;
    private boolean withHash = false;
    private Integer count = null;
    private boolean any = false;
    private SortingOrder sortingOrder = null;

    public static GeoRadiusParam geoRadiusParam() {
        return new GeoRadiusParam();
    }

    public GeoRadiusParam withCoord() {
        this.withCoord = true;
        return this;
    }

    public GeoRadiusParam withDist() {
        this.withDist = true;
        return this;
    }

    public GeoRadiusParam withHash() {
        this.withHash = true;
        return this;
    }

    public GeoRadiusParam sortAscending() {
        return this.sortingOrder(SortingOrder.ASC);
    }

    public GeoRadiusParam sortDescending() {
        return this.sortingOrder(SortingOrder.DESC);
    }

    public GeoRadiusParam sortingOrder(SortingOrder sortingOrder) {
        this.sortingOrder = sortingOrder;
        return this;
    }

    public GeoRadiusParam count(int n2) {
        if (n2 > 0) {
            this.count = n2;
        }
        return this;
    }

    public GeoRadiusParam count(int n2, boolean bl) {
        if (n2 > 0) {
            this.count = n2;
            if (bl) {
                this.any = true;
            }
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.withCoord) {
            commandArguments.add(Protocol.Keyword.WITHCOORD);
        }
        if (this.withDist) {
            commandArguments.add(Protocol.Keyword.WITHDIST);
        }
        if (this.withHash) {
            commandArguments.add(Protocol.Keyword.WITHHASH);
        }
        if (this.count != null) {
            commandArguments.add(Protocol.Keyword.COUNT).add(this.count);
            if (this.any) {
                commandArguments.add(Protocol.Keyword.ANY);
            }
        }
        if (this.sortingOrder != null) {
            commandArguments.add(this.sortingOrder);
        }
    }
}

