/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.params;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class FailoverParams
implements IParams {
    private HostAndPort to;
    private boolean force;
    private Long timeout;

    public static FailoverParams failoverParams() {
        return new FailoverParams();
    }

    public FailoverParams to(String string, int n2) {
        return this.to(new HostAndPort(string, n2));
    }

    public FailoverParams to(HostAndPort hostAndPort) {
        this.to = hostAndPort;
        return this;
    }

    public FailoverParams force() {
        this.force = true;
        return this;
    }

    public FailoverParams timeout(long l2) {
        this.timeout = l2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.to != null) {
            commandArguments.add(Protocol.Keyword.TO);
            commandArguments.add(this.to.getHost()).add(Protocol.toByteArray(this.to.getPort()));
        }
        if (this.force) {
            if (this.to == null || this.timeout == null) {
                throw new IllegalStateException("ERR FAILOVER with force option requires both a timeout and target HOST and IP.");
            }
            commandArguments.add(Protocol.Keyword.FORCE);
        }
        if (this.timeout != null) {
            commandArguments.add(Protocol.Keyword.TIMEOUT).add(Protocol.toByteArray(this.timeout));
        }
    }
}

