/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph.entities;

import java.util.List;
import java.util.Objects;

public final class Point {
    private static final double EPSILON = 1.0E-5;
    private final double latitude;
    private final double longitude;

    public Point(double d2, double d3) {
        this.latitude = d2;
        this.longitude = d3;
    }

    public Point(List<Double> list) {
        if (list == null || list.size() != 2) {
            throw new IllegalArgumentException("Point requires two doubles.");
        }
        this.latitude = list.get(0);
        this.longitude = list.get(1);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        return Math.abs(this.latitude - point.latitude) < 1.0E-5 && Math.abs(this.longitude - point.longitude) < 1.0E-5;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return "Point{latitude=" + this.latitude + ", longitude=" + this.longitude + "}";
    }
}

