/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph.entities;

import java.util.List;
import java.util.Objects;
import me.ulrich.clans.library.redis.jedis.graph.entities.Edge;
import me.ulrich.clans.library.redis.jedis.graph.entities.Node;

public final class Path {
    private final List<Node> nodes;
    private final List<Edge> edges;

    public Path(List<Node> list, List<Edge> list2) {
        this.nodes = list;
        this.edges = list2;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public int length() {
        return this.edges.size();
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public Node firstNode() {
        return this.nodes.get(0);
    }

    public Node lastNode() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public Node getNode(int n2) {
        return this.nodes.get(n2);
    }

    public Edge getEdge(int n2) {
        return this.edges.get(n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Path path = (Path)object;
        return Objects.equals(this.nodes, path.nodes) && Objects.equals(this.edges, path.edges);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.edges);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Path{");
        stringBuilder.append("nodes=").append(this.nodes);
        stringBuilder.append(", edges=").append(this.edges);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

