/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.ulrich.clans.library.redis.jedis.graph.entities.GraphEntity;

public class Node
extends GraphEntity {
    private final List<String> labels;

    public Node() {
        this.labels = new ArrayList<String>();
    }

    public Node(int n2, int n3) {
        super(n3);
        this.labels = new ArrayList<String>(n2);
    }

    public void addLabel(String string) {
        this.labels.add(string);
    }

    public void removeLabel(String string) {
        this.labels.remove(string);
    }

    public String getLabel(int n2) {
        return this.labels.get(n2);
    }

    public int getNumberOfLabels() {
        return this.labels.size();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Node)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Node node = (Node)object;
        return Objects.equals(this.labels, node.labels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.labels);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Node{");
        stringBuilder.append("labels=").append(this.labels);
        stringBuilder.append(", id=").append(this.id);
        stringBuilder.append(", propertyMap=").append(this.propertyMap);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

