/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph.entities;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.graph.entities.Property;

public abstract class GraphEntity {
    protected long id;
    protected final Map<String, Property<?>> propertyMap;

    public GraphEntity() {
        this.propertyMap = new HashMap();
    }

    public GraphEntity(int n2) {
        this.propertyMap = new HashMap(n2);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public void addProperty(String string, Object object) {
        this.addProperty(new Property<Object>(string, object));
    }

    public Set<String> getEntityPropertyNames() {
        return this.propertyMap.keySet();
    }

    public void addProperty(Property property) {
        this.propertyMap.put(property.getName(), property);
    }

    public int getNumberOfProperties() {
        return this.propertyMap.size();
    }

    public Property getProperty(String string) {
        return this.propertyMap.get(string);
    }

    public void removeProperty(String string) {
        this.propertyMap.remove(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GraphEntity)) {
            return false;
        }
        GraphEntity graphEntity = (GraphEntity)object;
        return this.id == graphEntity.id && Objects.equals(this.propertyMap, graphEntity.propertyMap);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.propertyMap);
    }

    public abstract String toString();
}

