/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisDataException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.graph.GraphCache;
import me.ulrich.clans.library.redis.jedis.graph.Header;
import me.ulrich.clans.library.redis.jedis.graph.Record;
import me.ulrich.clans.library.redis.jedis.graph.ResultSet;
import me.ulrich.clans.library.redis.jedis.graph.Statistics;
import me.ulrich.clans.library.redis.jedis.graph.entities.Edge;
import me.ulrich.clans.library.redis.jedis.graph.entities.GraphEntity;
import me.ulrich.clans.library.redis.jedis.graph.entities.Node;
import me.ulrich.clans.library.redis.jedis.graph.entities.Path;
import me.ulrich.clans.library.redis.jedis.graph.entities.Point;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

class ResultSetBuilder
extends Builder<ResultSet> {
    private final GraphCache graphCache;
    private static final ScalarType[] SCALAR_TYPES = ScalarType.values();
    private static final ResultSet.ColumnType[] COLUMN_TYPES = ResultSet.ColumnType.values();

    ResultSetBuilder(GraphCache graphCache) {
        this.graphCache = graphCache;
    }

    @Override
    public ResultSet build(Object object) {
        Object e2;
        List<Object> list;
        List<Object> list2;
        List list3 = (List)object;
        if (list3.get(list3.size() - 1) instanceof JedisDataException) {
            throw (JedisDataException)list3.get(list3.size() - 1);
        }
        if (list3.size() == 1) {
            list2 = Collections.emptyList();
            list = Collections.emptyList();
            e2 = list3.get(0);
        } else if (list3.size() == 3) {
            list2 = list3.get(0);
            list = list3.get(1);
            e2 = list3.get(2);
        } else {
            throw new JedisException("Unrecognized graph response format.");
        }
        HeaderImpl headerImpl = this.parseHeader(list2);
        List<Record> list4 = this.parseRecords(headerImpl, list);
        StatisticsImpl statisticsImpl = this.parseStatistics(e2);
        return new ResultSetImpl(headerImpl, list4, statisticsImpl);
    }

    private List<Record> parseRecords(Header header, Object object) {
        List list = (List)object;
        if (list == null || list.isEmpty()) {
            return new ArrayList<Record>(0);
        }
        ArrayList<Record> arrayList = new ArrayList<Record>(list.size());
        for (List list2 : list) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list2.size());
            block6: for (int i2 = 0; i2 < list2.size(); ++i2) {
                List list3 = (List)list2.get(i2);
                ResultSet.ColumnType columnType = header.getSchemaTypes().get(i2);
                switch (columnType) {
                    case NODE: {
                        arrayList2.add(this.deserializeNode(list3));
                        continue block6;
                    }
                    case RELATION: {
                        arrayList2.add(this.deserializeEdge(list3));
                        continue block6;
                    }
                    case SCALAR: {
                        arrayList2.add(this.deserializeScalar(list3));
                        continue block6;
                    }
                    default: {
                        arrayList2.add(null);
                    }
                }
            }
            RecordImpl recordImpl = new RecordImpl(header.getSchemaNames(), arrayList2);
            arrayList.add(recordImpl);
        }
        return arrayList;
    }

    private Node deserializeNode(List<Object> list) {
        List list2 = (List)list.get(1);
        List list3 = (List)list.get(2);
        Node node = new Node(list2.size(), list3.size());
        this.deserializeGraphEntityId(node, (Long)list.get(0));
        for (Long l2 : list2) {
            String string = this.graphCache.getLabel(l2.intValue());
            node.addLabel(string);
        }
        this.deserializeGraphEntityProperties(node, list3);
        return node;
    }

    private void deserializeGraphEntityId(GraphEntity graphEntity, long l2) {
        graphEntity.setId(l2);
    }

    private Edge deserializeEdge(List<Object> list) {
        List list2 = (List)list.get(4);
        Edge edge = new Edge(list2.size());
        this.deserializeGraphEntityId(edge, (Long)list.get(0));
        String string = this.graphCache.getRelationshipType(((Long)list.get(1)).intValue());
        edge.setRelationshipType(string);
        edge.setSource((Long)list.get(2));
        edge.setDestination((Long)list.get(3));
        this.deserializeGraphEntityProperties(edge, list2);
        return edge;
    }

    private void deserializeGraphEntityProperties(GraphEntity graphEntity, List<List<Object>> list) {
        for (List<Object> list2 : list) {
            String string = this.graphCache.getPropertyName(((Long)list2.get(0)).intValue());
            List<Object> list3 = list2.subList(1, list2.size());
            graphEntity.addProperty(string, this.deserializeScalar(list3));
        }
    }

    private Object deserializeScalar(List<Object> list) {
        ScalarType scalarType = this.getValueTypeFromObject(list.get(0));
        Object object = list.get(1);
        switch (scalarType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(SafeEncoder.encode((byte[])object));
            }
            case DOUBLE: {
                return BuilderFactory.DOUBLE.build(object);
            }
            case INTEGER: {
                return (Long)object;
            }
            case STRING: {
                return SafeEncoder.encode((byte[])object);
            }
            case ARRAY: {
                return this.deserializeArray(object);
            }
            case NODE: {
                return this.deserializeNode((List)object);
            }
            case EDGE: {
                return this.deserializeEdge((List)object);
            }
            case PATH: {
                return this.deserializePath(object);
            }
            case MAP: {
                return this.deserializeMap(object);
            }
            case POINT: {
                return this.deserializePoint(object);
            }
        }
        return object;
    }

    private Object deserializePoint(Object object) {
        return new Point(BuilderFactory.DOUBLE_LIST.build(object));
    }

    private Map<String, Object> deserializeMap(Object object) {
        List list = (List)object;
        int n2 = list.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n2 >> 1);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = SafeEncoder.encode((byte[])list.get(i2));
            Object object2 = this.deserializeScalar((List)list.get(i2 + 1));
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    private Path deserializePath(Object object) {
        List list = (List)object;
        List list2 = (List)this.deserializeScalar((List)list.get(0));
        List list3 = (List)this.deserializeScalar((List)list.get(1));
        return new Path(list2, list3);
    }

    private List<Object> deserializeArray(Object object) {
        List list = (List)object;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (List list2 : list) {
            arrayList.add(this.deserializeScalar(list2));
        }
        return arrayList;
    }

    private ScalarType getValueTypeFromObject(Object object) {
        return ResultSetBuilder.getScalarType(((Long)object).intValue());
    }

    private static ScalarType getScalarType(int n2) {
        try {
            return SCALAR_TYPES[n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JedisException("Unrecognized response type");
        }
    }

    private HeaderImpl parseHeader(Object object) {
        if (object == null) {
            return new HeaderImpl();
        }
        List list = (List)object;
        ArrayList<ResultSet.ColumnType> arrayList = new ArrayList<ResultSet.ColumnType>(list.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(list.size());
        for (List list2 : list) {
            arrayList.add(COLUMN_TYPES[((Long)list2.get(0)).intValue()]);
            arrayList2.add(SafeEncoder.encode((byte[])list2.get(1)));
        }
        return new HeaderImpl(arrayList, arrayList2);
    }

    private StatisticsImpl parseStatistics(Object object) {
        Map<String, String> map = ((List)object).stream().map(SafeEncoder::encode).map(string -> string.split(": ")).collect(Collectors.toMap(stringArray -> stringArray[0], stringArray -> stringArray[1]));
        return new StatisticsImpl(map);
    }

    private class StatisticsImpl
    implements Statistics {
        private final Map<String, String> statistics;

        private StatisticsImpl(Map<String, String> map) {
            this.statistics = map;
        }

        public String getStringValue(String string) {
            return this.statistics.get(string);
        }

        private int getIntValue(String string) {
            String string2 = this.getStringValue(string);
            return string2 == null ? 0 : Integer.parseInt(string2);
        }

        @Override
        public int nodesCreated() {
            return this.getIntValue("Nodes created");
        }

        @Override
        public int nodesDeleted() {
            return this.getIntValue("Nodes deleted");
        }

        @Override
        public int indicesCreated() {
            return this.getIntValue("Indices created");
        }

        @Override
        public int indicesDeleted() {
            return this.getIntValue("Indices deleted");
        }

        @Override
        public int labelsAdded() {
            return this.getIntValue("Labels added");
        }

        @Override
        public int relationshipsDeleted() {
            return this.getIntValue("Relationships deleted");
        }

        @Override
        public int relationshipsCreated() {
            return this.getIntValue("Relationships created");
        }

        @Override
        public int propertiesSet() {
            return this.getIntValue("Properties set");
        }

        @Override
        public boolean cachedExecution() {
            return "1".equals(this.getStringValue("Cached execution"));
        }

        @Override
        public String queryIntervalExecutionTime() {
            return this.getStringValue("Query internal execution time");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StatisticsImpl)) {
                return false;
            }
            StatisticsImpl statisticsImpl = (StatisticsImpl)object;
            return Objects.equals(this.statistics, statisticsImpl.statistics);
        }

        public int hashCode() {
            return Objects.hash(this.statistics);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Statistics{");
            stringBuilder.append(this.statistics);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private class HeaderImpl
    implements Header {
        private final List<ResultSet.ColumnType> schemaTypes;
        private final List<String> schemaNames;

        private HeaderImpl() {
            this.schemaTypes = Collections.emptyList();
            this.schemaNames = Collections.emptyList();
        }

        private HeaderImpl(List<ResultSet.ColumnType> list, List<String> list2) {
            this.schemaTypes = list;
            this.schemaNames = list2;
        }

        @Override
        public List<String> getSchemaNames() {
            return this.schemaNames;
        }

        @Override
        public List<ResultSet.ColumnType> getSchemaTypes() {
            return this.schemaTypes;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HeaderImpl)) {
                return false;
            }
            HeaderImpl headerImpl = (HeaderImpl)object;
            return Objects.equals(this.getSchemaTypes(), headerImpl.getSchemaTypes()) && Objects.equals(this.getSchemaNames(), headerImpl.getSchemaNames());
        }

        public int hashCode() {
            return Objects.hash(this.getSchemaTypes(), this.getSchemaNames());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("HeaderImpl{");
            stringBuilder.append("schemaTypes=").append(this.schemaTypes);
            stringBuilder.append(", schemaNames=").append(this.schemaNames);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private class RecordImpl
    implements Record {
        private final List<String> header;
        private final List<Object> values;

        public RecordImpl(List<String> list, List<Object> list2) {
            this.header = list;
            this.values = list2;
        }

        @Override
        public <T> T getValue(int n2) {
            return (T)this.values.get(n2);
        }

        @Override
        public <T> T getValue(String string) {
            return this.getValue(this.header.indexOf(string));
        }

        @Override
        public String getString(int n2) {
            return this.values.get(n2).toString();
        }

        @Override
        public String getString(String string) {
            return this.getString(this.header.indexOf(string));
        }

        @Override
        public List<String> keys() {
            return this.header;
        }

        @Override
        public List<Object> values() {
            return this.values;
        }

        @Override
        public boolean containsKey(String string) {
            return this.header.contains(string);
        }

        @Override
        public int size() {
            return this.header.size();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RecordImpl)) {
                return false;
            }
            RecordImpl recordImpl = (RecordImpl)object;
            return Objects.equals(this.header, recordImpl.header) && Objects.equals(this.values, recordImpl.values);
        }

        public int hashCode() {
            return Objects.hash(this.header, this.values);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Record{");
            stringBuilder.append("values=").append(this.values);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static enum ScalarType {
        UNKNOWN,
        NULL,
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE,
        ARRAY,
        EDGE,
        NODE,
        PATH,
        MAP,
        POINT;

    }

    private class ResultSetImpl
    implements ResultSet {
        private final Header header;
        private final List<Record> results;
        private final Statistics statistics;

        private ResultSetImpl(Header header, List<Record> list, Statistics statistics) {
            this.header = header;
            this.results = list;
            this.statistics = statistics;
        }

        @Override
        public Header getHeader() {
            return this.header;
        }

        @Override
        public Statistics getStatistics() {
            return this.statistics;
        }

        @Override
        public int size() {
            return this.results.size();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ResultSetImpl)) {
                return false;
            }
            ResultSetImpl resultSetImpl = (ResultSetImpl)object;
            return Objects.equals(this.getHeader(), resultSetImpl.getHeader()) && Objects.equals(this.getStatistics(), resultSetImpl.getStatistics()) && Objects.equals(this.results, resultSetImpl.results);
        }

        public int hashCode() {
            return Objects.hash(this.getHeader(), this.getStatistics(), this.results);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ResultSetImpl{");
            stringBuilder.append("header=").append(this.header);
            stringBuilder.append(", statistics=").append(this.statistics);
            stringBuilder.append(", results=").append(this.results);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public Iterator<Record> iterator() {
            return this.results.iterator();
        }
    }
}

